/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.logic;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.CircuitsPlugin;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.ic.RestrictedIC;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;

public class Pulser
extends AbstractIC {
    private int pulseLength = 5;
    private int startDelay = 1;
    private int pulseCount = 1;
    private int pauseLength = 5;
    private int taskId;
    private boolean running;

    public Pulser(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    public void load() {
        String[] split;
        String line2 = this.getSign().getLine(2);
        String line3 = this.getSign().getLine(3);
        if (line2 != null && !line2.isEmpty()) {
            split = ICUtil.COLON_PATTERN.split(line2, 2);
            this.pulseLength = Integer.parseInt(split[0]);
            if (split.length > 1) {
                this.startDelay = Integer.parseInt(split[1]);
            }
        }
        if (line3 != null && !line3.isEmpty()) {
            split = ICUtil.COLON_PATTERN.split(line3, 2);
            this.pulseCount = Integer.parseInt(split[0]);
            if (split.length > 1) {
                this.pauseLength = Integer.parseInt(split[1]);
            }
        }
        this.getSign().setLine(2, this.pulseLength + ":" + this.startDelay);
        this.getSign().setLine(3, this.pulseCount + ":" + this.pauseLength);
        this.getSign().update(false);
    }

    public String getTitle() {
        return "Pulser";
    }

    public String getSignTitle() {
        return "PULSER";
    }

    public final void trigger(ChipState chip) {
        if (this.getInput(chip)) {
            this.startThread(chip);
        }
    }

    private void startThread(ChipState chip) {
        if (this.running) {
            return;
        }
        this.taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)CircuitsPlugin.getInst(), (Runnable)new PulseTask(chip, this.pulseLength, this.pulseCount, this.pauseLength), (long)this.startDelay, 1L);
        this.running = true;
    }

    private void stopThread() {
        Bukkit.getScheduler().cancelTask(this.taskId);
        this.running = false;
    }

    protected boolean getInput(ChipState chip) {
        return chip.getInput(0);
    }

    protected void setOutput(ChipState chip, boolean on) {
        chip.setOutput(0, on);
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new Pulser(this.getServer(), sign, this);
        }

        public void verify(ChangedSign sign) throws ICVerificationException {
            String[] split;
            String line2 = sign.getLine(2);
            String line3 = sign.getLine(3);
            if (line2 != null && !line2.isEmpty()) {
                try {
                    split = ICUtil.COLON_PATTERN.split(line2, 2);
                    Integer.parseInt(split[0]);
                    if (split.length > 1) {
                        Integer.parseInt(split[1]);
                    }
                }
                catch (Exception e) {
                    throw new ICVerificationException("You can only write numbers in line 3. See /icdocs for help");
                }
            }
            if (line3 != null && !line3.isEmpty()) {
                try {
                    split = ICUtil.COLON_PATTERN.split(line3, 2);
                    Integer.parseInt(split[0]);
                    if (split.length > 1) {
                        Integer.parseInt(split[1]);
                    }
                }
                catch (Exception e) {
                    throw new ICVerificationException("You can only write numbers in line 4. See /icdocs for help");
                }
            }
        }

        public String getDescription() {
            return "Fires a (choosable) pulse of high-signals with a choosable length of the signal and the pause between the pulses when the input goes from low to high.";
        }

        public String[] getLineHelp() {
            return new String[]{"[pulselength[:startdelay]]", "[pulsecount[:pauselength in serverticks]]"};
        }
    }

    protected class PulseTask
    implements Runnable {
        private final ChipState chip;
        private final int pulseLength;
        private final int pulseCount;
        private final int pauseLength;
        private int currentTick;
        private int currentPulseCount;
        private int currentPulse;
        private boolean on = false;

        public PulseTask(ChipState chip, int pulseLength, int pulseCount, int pauseLength) {
            if (pulseLength == 0) {
                pulseLength = 1;
            }
            if (pauseLength == 0) {
                pauseLength = 1;
            }
            this.chip = chip;
            this.pulseLength = pulseLength;
            this.pulseCount = pulseCount;
            this.pauseLength = pauseLength;
        }

        public void run() {
            ++this.currentTick;
            if (this.currentTick < 2) {
                this.startPulse();
                return;
            }
            if (this.on) {
                if (this.currentPulse % this.pulseLength == 0) {
                    this.stopPulse();
                } else {
                    this.increasePulse();
                }
            } else if (this.currentTick % this.pauseLength == 0) {
                this.startPulse();
            }
            if (!this.on && this.currentPulseCount % this.pulseCount == 0) {
                Pulser.this.stopThread();
            }
        }

        private void startPulse() {
            Pulser.this.setOutput(this.chip, true);
            ++this.currentPulse;
            this.on = true;
        }

        private void stopPulse() {
            Pulser.this.setOutput(this.chip, false);
            this.currentPulse = 0;
            ++this.currentPulseCount;
            this.on = false;
        }

        private void increasePulse() {
            ++this.currentPulse;
        }
    }
}

