/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.logic;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.SelfTriggeredIC;
import java.util.regex.Pattern;
import org.bukkit.Server;

public class RangedOutput
extends AbstractIC
implements SelfTriggeredIC {
    private static final Pattern MINUS_PATTERN = Pattern.compile("-", 16);
    int ticks = 0;
    int maxTicks = 0;
    boolean hasStarted = false;
    int amountDone = 0;
    int maxAmount = 0;

    public RangedOutput(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public String getTitle() {
        return "Ranged Output";
    }

    public String getSignTitle() {
        return "RANGE OUTPUT";
    }

    public void think(ChipState chip) {
        chip.setOutput(0, this.shouldOutput(chip));
    }

    protected boolean shouldOutput(ChipState chip) {
        if (chip.getInput(0)) {
            String[] minmax = MINUS_PATTERN.split(this.getSign().getLine(2));
            int min = Integer.parseInt(minmax[0]);
            int max = Integer.parseInt(minmax[1]);
            this.maxAmount = min + (int)(Math.random() * (double)(max - min + 1));
            this.amountDone = 0;
            this.ticks = 0;
            this.maxTicks = this.getSign().getLine(3) != null || this.getSign().getLine(3).isEmpty() ? Integer.parseInt(this.getSign().getLine(3)) : 10;
            this.hasStarted = true;
            return false;
        }
        if (this.hasStarted) {
            if (this.ticks >= this.maxTicks) {
                ++this.amountDone;
                if (this.amountDone >= this.maxAmount) {
                    this.hasStarted = false;
                    this.amountDone = 0;
                    this.ticks = 0;
                    this.maxAmount = 0;
                }
                return true;
            }
            ++this.ticks;
            return false;
        }
        return false;
    }

    public boolean isActive() {
        return true;
    }

    public void trigger(ChipState chip) {
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new RangedOutput(this.getServer(), sign, this);
        }
    }
}

