/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.blocks;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.bukkit.CircuitsPlugin;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.util.BlockUtil;
import com.sk89q.craftbook.util.SignUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.PistonBaseMaterial;

public class BlockBreaker
extends AbstractIC {
    boolean above;
    Block broken;
    Block chest;
    int id;
    byte data;

    public BlockBreaker(Server server, ChangedSign block, boolean above, ICFactory factory) {
        super(server, block, factory);
        this.above = above;
    }

    public String getTitle() {
        return "Block Breaker";
    }

    public String getSignTitle() {
        return "BLOCK BREAK";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.breakBlock());
        }
    }

    public void load() {
        Block bl = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock());
        if (this.above) {
            this.chest = bl.getRelative(0, 1, 0);
            this.broken = bl.getRelative(0, -1, 0);
        } else {
            this.chest = bl.getRelative(0, -1, 0);
            this.broken = bl.getRelative(0, 1, 0);
        }
        try {
            String[] split = ICUtil.COLON_PATTERN.split(this.getSign().getLine(2));
            this.id = Integer.parseInt(split[0]);
            this.data = Byte.parseByte(split[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean breakBlock() {
        boolean hasChest = false;
        if (this.chest != null && this.chest.getTypeId() == 54) {
            hasChest = true;
        }
        if (this.broken == null || this.broken.getTypeId() == 0 || this.broken.getTypeId() == 7 || this.broken.getTypeId() == 36) {
            return false;
        }
        if (this.id > 0 && this.id != this.broken.getTypeId()) {
            return false;
        }
        if (this.data > 0 && this.data != this.broken.getData()) {
            return false;
        }
        this.broken.getDrops();
        for (ItemStack blockstack : this.broken.getDrops()) {
            PistonBaseMaterial p;
            Block fac;
            BlockFace back = SignUtil.getBack((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock());
            Block pipe = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()).getRelative(back);
            if (pipe.getTypeId() == 29 && (fac = pipe.getRelative((p = (PistonBaseMaterial)pipe.getState().getData()).getFacing())).getLocation().equals((Object)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock().getRelative(back).getLocation())) {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                items.add(blockstack);
                if (CircuitsPlugin.getInst().pipeFactory != null && CircuitsPlugin.getInst().pipeFactory.detect(BukkitUtil.toWorldVector((Block)pipe), items) != null) continue;
            }
            if (hasChest) {
                Chest c = (Chest)this.chest.getState();
                HashMap overflow = c.getInventory().addItem(new ItemStack[]{blockstack});
                if (overflow.isEmpty()) continue;
                for (Map.Entry bit : overflow.entrySet()) {
                    this.dropItem((ItemStack)bit.getValue());
                }
                continue;
            }
            this.dropItem(blockstack);
        }
        this.broken.setTypeId(0);
        return true;
    }

    public void dropItem(ItemStack item) {
        BukkitUtil.toSign((ChangedSign)this.getSign()).getWorld().dropItem(BlockUtil.getBlockCentre((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()), item);
    }

    public static class Factory
    extends AbstractICFactory {
        boolean above;

        public Factory(Server server, boolean above) {
            super(server);
            this.above = above;
        }

        public IC create(ChangedSign sign) {
            return new BlockBreaker(this.getServer(), sign, this.above, this);
        }

        public String getDescription() {
            return "Breaks blocks above/below block sign is on.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"Optional block ID", null};
            return lines;
        }
    }
}

