/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.blocks;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.bukkit.CircuitsPlugin;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.Vector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.PistonBaseMaterial;

public class CombineHarvester
extends AbstractIC {
    Vector offset = new Vector(0, 2, 0);
    int radius = 10;
    Block target;
    Block onBlock;

    public CombineHarvester(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public void load() {
        this.onBlock = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock());
        try {
            this.radius = Integer.parseInt(ICUtil.EQUALS_PATTERN.split(this.getSign().getLine(3))[0]);
            try {
                String[] loc = ICUtil.COLON_PATTERN.split(ICUtil.EQUALS_PATTERN.split(this.getSign().getLine(3))[1]);
                this.offset = new Vector(Integer.parseInt(loc[0]), Integer.parseInt(loc[1]), Integer.parseInt(loc[2]));
                if (this.offset.getX() > 16.0) {
                    this.offset.setX(16);
                }
                if (this.offset.getY() > 16.0) {
                    this.offset.setY(16);
                }
                if (this.offset.getZ() > 16.0) {
                    this.offset.setZ(16);
                }
                if (this.offset.getX() < -16.0) {
                    this.offset.setX(-16);
                }
                if (this.offset.getY() < -16.0) {
                    this.offset.setY(-16);
                }
                if (this.offset.getZ() < -16.0) {
                    this.offset.setZ(-16);
                }
            }
            catch (Exception e) {
                this.offset = new Vector(0, 2, 0);
            }
        }
        catch (Exception e) {
            this.radius = 10;
            this.offset = new Vector(0, 2, 0);
        }
        this.target = this.onBlock.getRelative(this.offset.getBlockX(), this.offset.getBlockY(), this.offset.getBlockZ());
    }

    public String getTitle() {
        return "Combine Harvester";
    }

    public String getSignTitle() {
        return "HARVEST";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.harvest());
        }
    }

    public boolean harvest() {
        for (int x = -this.radius + 1; x < this.radius; ++x) {
            for (int y = -this.radius + 1; y < this.radius; ++y) {
                for (int z = -this.radius + 1; z < this.radius; ++z) {
                    int rx = this.target.getX() - x;
                    int ry = this.target.getY() - y;
                    int rz = this.target.getZ() - z;
                    Block b = BukkitUtil.toSign((ChangedSign)this.getSign()).getWorld().getBlockAt(rx, ry, rz);
                    if (!this.harvestable(b)) continue;
                    this.collectDrops(b.getDrops().toArray(new ItemStack[b.getDrops().size()]));
                    b.setTypeId(0);
                    return true;
                }
            }
        }
        return false;
    }

    public void collectDrops(ItemStack[] drops) {
        PistonBaseMaterial p;
        Block fac;
        BlockFace back = SignUtil.getBack((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock());
        Block pipe = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()).getRelative(back);
        if (pipe.getTypeId() == 29 && (fac = pipe.getRelative((p = (PistonBaseMaterial)pipe.getState().getData()).getFacing())).getLocation().equals((Object)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock().getRelative(back).getLocation())) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            Collections.addAll(items, drops);
            if (CircuitsPlugin.getInst().pipeFactory != null && CircuitsPlugin.getInst().pipeFactory.detect(BukkitUtil.toWorldVector((Block)pipe), items) != null) {
                return;
            }
        }
        if (this.onBlock.getRelative(0, 1, 0).getTypeId() == 54) {
            Chest c = (Chest)this.onBlock.getRelative(0, 1, 0).getState();
            HashMap leftovers = c.getInventory().addItem(drops);
            for (ItemStack item : leftovers.values()) {
                this.onBlock.getWorld().dropItemNaturally(BukkitUtil.toSign((ChangedSign)this.getSign()).getLocation().add(0.5, 0.0, 0.5), item);
            }
        } else {
            for (ItemStack item : drops) {
                this.onBlock.getWorld().dropItemNaturally(BukkitUtil.toSign((ChangedSign)this.getSign()).getLocation().add(0.5, 0.0, 0.5), item);
            }
        }
    }

    public boolean harvestable(Block block) {
        return (block.getTypeId() == 59 || block.getTypeId() == 141 || block.getTypeId() == 142) && block.getData() >= 7;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new CombineHarvester(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Harvests nearby crops.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"radius=x:y:z offset", null};
            return lines;
        }
    }
}

