/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.blocks;

import com.sk89q.craftbook.BaseConfiguration;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.Vector;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.inventory.ItemStack;

public class Cultivator
extends AbstractIC {
    int maxradius = -1;
    int radius;

    public Cultivator(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public String getTitle() {
        return "Cultivator";
    }

    public String getSignTitle() {
        return "CULTIVATOR";
    }

    public void load() {
        if (this.maxradius == -1) {
            this.maxradius = ((Factory)this.getFactory()).maxradius;
        }
        try {
            this.radius = Integer.parseInt(this.getSign().getLine(2));
            if (this.radius > this.maxradius) {
                this.radius = this.maxradius;
                this.getSign().setLine(2, String.valueOf(this.maxradius));
                this.getSign().update(false);
            }
        }
        catch (Exception e) {
            this.radius = 10;
        }
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.cultivate());
        }
    }

    public boolean cultivate() {
        BlockWorldVector position = this.getSign().getBlockVector();
        for (int x = -this.radius + 1; x < this.radius; ++x) {
            for (int y = -this.radius + 1; y < this.radius; ++y) {
                for (int z = -this.radius + 1; z < this.radius; ++z) {
                    BlockWorldVector current = new BlockWorldVector(this.getSign().getLocalWorld(), (Vector)position.subtract(x, y, z).toBlockPoint());
                    Block b = BukkitUtil.toBlock((BlockWorldVector)current);
                    if (b.getTypeId() != 3 && b.getTypeId() != 2 || !this.damageHoe()) continue;
                    b.setTypeId(60);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean damageHoe() {
        Block chest = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()).getRelative(0, 1, 0);
        if (chest.getTypeId() == 54) {
            Chest c = (Chest)chest.getState();
            for (int i = 290; i < 294; ++i) {
                for (int slot = 0; slot < c.getInventory().getSize(); ++slot) {
                    if (c.getInventory().getItem(slot) == null || c.getInventory().getItem(slot).getTypeId() != i || !ItemUtil.isStackValid((ItemStack)c.getInventory().getItem(slot))) continue;
                    ItemStack item = c.getInventory().getItem(slot);
                    item.setDurability((short)(item.getDurability() + 1));
                    c.getInventory().setItem(slot, item);
                    return true;
                }
            }
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory {
        int maxradius;

        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new Cultivator(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Cultivates an area using a hoe.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"radius", null};
            return lines;
        }

        public void addConfiguration(BaseConfiguration.BaseConfigurationSection section) {
            this.maxradius = section.getInt("max-radius", 15);
        }

        public boolean needsConfiguration() {
            return true;
        }
    }
}

