/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.blocks;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.util.SignUtil;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.inventory.ItemStack;

public class Irrigator
extends AbstractIC {
    Location centre;
    int radius;

    public Irrigator(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public void load() {
        this.centre = BukkitUtil.toSign((ChangedSign)this.getSign()).getLocation();
        try {
            String[] splitEquals = ICUtil.EQUALS_PATTERN.split(this.getSign().getLine(2), 2);
            this.radius = Integer.parseInt(splitEquals[0]);
            if (this.getSign().getLine(2).contains("=")) {
                String[] splitCoords = ICUtil.COLON_PATTERN.split(splitEquals[1]);
                int x = Integer.parseInt(splitCoords[0]);
                int y = Integer.parseInt(splitCoords[1]);
                int z = Integer.parseInt(splitCoords[2]);
                if (x > 16) {
                    x = 16;
                }
                if (x < -16) {
                    x = -16;
                }
                if (y > 16) {
                    y = 16;
                }
                if (y < -16) {
                    y = -16;
                }
                if (z > 16) {
                    z = 16;
                }
                if (z < -16) {
                    z = -16;
                }
                this.centre.add((double)x, (double)y, (double)z);
            }
        }
        catch (Exception ignored) {
            this.radius = 10;
        }
    }

    public String getTitle() {
        return "Irrigator";
    }

    public String getSignTitle() {
        return "IRRIGATOR";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.irrigate());
        }
    }

    public boolean irrigate() {
        for (int x = -this.radius + 1; x < this.radius; ++x) {
            for (int y = -this.radius + 1; y < this.radius; ++y) {
                for (int z = -this.radius + 1; z < this.radius; ++z) {
                    int rx = this.centre.getBlockX() - x;
                    int ry = this.centre.getBlockY() - y;
                    int rz = this.centre.getBlockZ() - z;
                    Block b = this.centre.getWorld().getBlockAt(rx, ry, rz);
                    if (b.getTypeId() != 60 || b.getData() >= 1 || !this.consumeWater()) continue;
                    b.setData((byte)8, false);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean consumeWater() {
        Block chest = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()).getRelative(0, 1, 0);
        if (chest.getTypeId() == 54) {
            Chest c = (Chest)chest.getState();
            HashMap over = c.getInventory().removeItem(new ItemStack[]{new ItemStack(8, 1)});
            if (over.isEmpty()) {
                return true;
            }
            over = c.getInventory().removeItem(new ItemStack[]{new ItemStack(9, 1)});
            if (over.isEmpty()) {
                return true;
            }
            over = c.getInventory().removeItem(new ItemStack[]{new ItemStack(326, 1)});
            if (over.isEmpty()) {
                c.getInventory().addItem(new ItemStack[]{new ItemStack(325, 1)});
                return true;
            }
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new Irrigator(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Irrigates nearby farmland using water in above chest.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"radius=x:y:z offset", null};
            return lines;
        }
    }
}

