/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.blocks;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.SignUtil;
import java.util.regex.Pattern;
import org.bukkit.Server;
import org.bukkit.block.Block;

public class MultipleSetBlock
extends AbstractIC {
    private static final Pattern PLUS_PATTERN = Pattern.compile("+", 16);
    int x;
    int y;
    int z;
    int block;
    byte data;
    String[] dim;

    public MultipleSetBlock(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public void load() {
        String line3 = this.getSign().getLine(2).toUpperCase();
        String line4 = this.getSign().getLine(3);
        String[] coords = ICUtil.COLON_PATTERN.split(PLUS_PATTERN.matcher(line3).replaceAll(""));
        Block body = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock());
        this.x = body.getX();
        this.y = body.getY();
        this.z = body.getZ();
        if (coords.length < 4) {
            return;
        }
        try {
            this.block = Integer.parseInt(coords[3]);
        }
        catch (Exception e) {
            return;
        }
        if (coords.length == 5) {
            try {
                this.data = Byte.parseByte(coords[4]);
            }
            catch (Exception e) {
                return;
            }
        }
        this.x += Integer.parseInt(coords[0]);
        this.y += Integer.parseInt(coords[1]);
        this.z += Integer.parseInt(coords[2]);
        this.dim = ICUtil.COLON_PATTERN.split(line4);
    }

    public String getTitle() {
        return "Multiple SetBlock";
    }

    public String getSignTitle() {
        return "MULTI-SET BLOCK";
    }

    public void trigger(ChipState chip) {
        chip.setOutput(0, chip.getInput(0));
        boolean inp = chip.getInput(0);
        if (!inp) {
            this.block = 0;
        }
        Block body = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock());
        if (this.dim.length == 3) {
            int dimX = Integer.parseInt(this.dim[0]);
            int dimY = Integer.parseInt(this.dim[1]);
            int dimZ = Integer.parseInt(this.dim[2]);
            for (int lx = 0; lx < dimX; ++lx) {
                for (int ly = 0; ly < dimY; ++ly) {
                    for (int lz = 0; lz < dimZ; ++lz) {
                        body.getWorld().getBlockAt(this.x + lx, this.y + ly, this.z + lz).setTypeIdAndData(this.block, this.data, true);
                    }
                }
            }
        } else {
            body.getWorld().getBlockAt(this.x, this.y, this.z).setTypeIdAndData(this.block, this.data, true);
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new MultipleSetBlock(this.getServer(), sign, this);
        }
    }
}

