/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.blocks;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.blocks.BlockType;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.inventory.ItemStack;

public abstract class SetBlock
extends AbstractIC {
    int block;
    String force;
    byte meta = (byte)-1;

    public SetBlock(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public void load() {
        String[] splitBlockData = ICUtil.COLON_PATTERN.split(this.getSign().getLine(2).toUpperCase().trim(), 2);
        String strBlock = splitBlockData[0];
        String strMeta = "";
        if (splitBlockData.length > 1) {
            strMeta = splitBlockData[1];
        }
        this.force = this.getSign().getLine(3).toUpperCase().trim();
        try {
            this.block = Integer.parseInt(strBlock);
        }
        catch (Exception e) {
            try {
                this.block = BlockType.lookup((String)strBlock).getID();
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        try {
            if (!strMeta.isEmpty()) {
                this.meta = Byte.parseByte(strMeta);
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
    }

    public void onTrigger() {
        if (BlockType.fromID((int)this.block) == null || this.block >= 256) {
            return;
        }
        Block body = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock());
        this.doSet(body, this.block, this.meta, this.force.equals("FORCE"));
    }

    public void trigger(ChipState chip) {
        chip.setOutput(0, chip.getInput(0));
        this.onTrigger();
    }

    protected abstract void doSet(Block var1, int var2, byte var3, boolean var4);

    public boolean takeFromChest(Block bl, int id, byte data) {
        if (bl.getTypeId() != 54) {
            return false;
        }
        BlockState state = bl.getState();
        if (!(state instanceof Chest)) {
            return false;
        }
        Chest c = (Chest)state;
        ItemStack[] is = c.getInventory().getContents();
        for (int i = 0; i < is.length; ++i) {
            ItemStack stack = is[i];
            if (stack == null || stack.getAmount() <= 0 || stack.getTypeId() != id || data != -1 && stack.getData().getData() != data) continue;
            if (stack.getAmount() == 1) {
                is[i] = new ItemStack(0, 0);
            } else {
                stack.setAmount(stack.getAmount() - 1);
            }
            c.getInventory().setContents(is);
            c.update();
            return true;
        }
        return false;
    }
}

