/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.entity;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.gates.world.entity.CreatureSpawner;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.Location;
import com.sk89q.worldedit.Vector;
import java.util.regex.Pattern;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class AdvancedEntitySpawner
extends AbstractIC {
    private static final Pattern ASTERISK_PATTERN = Pattern.compile("*", 16);
    private static final Pattern COLON_PATTERN = Pattern.compile(":", 16);
    private static final Pattern SEMICOLON_PATTERN = Pattern.compile(";", 16);
    private static final Pattern COMMA_PATTERN = Pattern.compile(",", 16);
    Location location;
    EntityType type;
    int amount = 1;

    public AdvancedEntitySpawner(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public String getTitle() {
        return "Advanced Entity Spawner";
    }

    public String getSignTitle() {
        return "ADV ENT SPAWNER";
    }

    public void load() {
        String[] splitLine3 = ASTERISK_PATTERN.split(this.getSign().getLine(3).trim());
        this.type = EntityType.fromName((String)splitLine3[0].toLowerCase());
        if (this.type == null) {
            this.type = EntityType.PIG;
        }
        try {
            this.amount = Integer.parseInt(splitLine3[1]);
        }
        catch (Exception e) {
            this.amount = 1;
        }
        try {
            String[] splitLine2 = COLON_PATTERN.split(this.getSign().getLine(2));
            double x = Double.parseDouble(splitLine2[0]);
            double y = Double.parseDouble(splitLine2[1]);
            double z = Double.parseDouble(splitLine2[2]);
            this.location = new Location(this.getSign().getLocalWorld(), new Vector(x += (double)this.getSign().getX(), y += (double)this.getSign().getY(), z += (double)this.getSign().getZ()));
        }
        catch (Exception e) {
            this.location = new Location(this.getSign().getLocalWorld(), new Vector(this.getSign().getX(), this.getSign().getY(), this.getSign().getZ()));
        }
    }

    public void trigger(ChipState chip) {
        if (!chip.getInput(0)) {
            return;
        }
        Block left = SignUtil.getLeftBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock());
        ChangedSign effectSign = null;
        if (left.getTypeId() == 68) {
            effectSign = BukkitUtil.toChangedSign((Block)left);
        }
        Block right = SignUtil.getRightBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock());
        ChangedSign armourSign = null;
        if (right.getTypeId() == 68) {
            armourSign = BukkitUtil.toChangedSign((Block)right);
        }
        block14: for (int i = 0; i < this.amount; ++i) {
            String bit;
            int s;
            Entity ent = BukkitUtil.toSign((ChangedSign)this.getSign()).getWorld().spawnEntity(BukkitUtil.toLocation((Location)this.location), this.type);
            if (armourSign != null && ent instanceof LivingEntity) {
                ItemStack[] armour = new ItemStack[4];
                for (s = 0; s < 4; ++s) {
                    try {
                        bit = armourSign.getLine(s);
                        if (bit == null || bit.trim().isEmpty()) continue;
                        byte data = 0;
                        String[] bitSplit = SEMICOLON_PATTERN.split(bit);
                        try {
                            data = Byte.parseByte(COLON_PATTERN.split(bitSplit[0])[1]);
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                        ItemStack slot = new ItemStack(Integer.parseInt(COLON_PATTERN.split(bitSplit[0])[0]), 1, (short)data);
                        try {
                            for (int e = 1; e < bitSplit.length; ++e) {
                                String[] enchantInfo = COLON_PATTERN.split(bitSplit[e]);
                                slot.addEnchantment(Enchantment.getById((int)Integer.parseInt(enchantInfo[0])), Integer.parseInt(enchantInfo[1]));
                            }
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                        armour[s] = slot;
                        continue;
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
                ((LivingEntity)ent).getEquipment().setArmorContents(armour);
            }
            Boolean upwards = null;
            while (effectSign != null) {
                for (s = 0; s < 4; ++s) {
                    bit = effectSign.getLine(s);
                    if (bit == null || bit.trim().isEmpty()) continue;
                    String[] data = COLON_PATTERN.split(bit);
                    if (data[0].equalsIgnoreCase("e")) {
                        CreatureSpawner.setEntityData(ent, bit.substring(2));
                        continue;
                    }
                    if (data[0].equalsIgnoreCase("r")) {
                        EntityType rider = EntityType.fromName((String)data[1].trim());
                        Entity rid = BukkitUtil.toSign((ChangedSign)this.getSign()).getWorld().spawnEntity(BukkitUtil.toLocation((Location)this.location), rider);
                        ent.setPassenger(rid);
                        continue;
                    }
                    if (data[0].equalsIgnoreCase("p") && ent instanceof LivingEntity) {
                        for (int a = 1; a < data.length; ++a) {
                            try {
                                String[] potionBits = SEMICOLON_PATTERN.split(data[a]);
                                PotionEffect effect = new PotionEffect(PotionEffectType.getById((int)Integer.parseInt(potionBits[0])), Integer.parseInt(potionBits[1]), Integer.parseInt(potionBits[2]));
                                ((LivingEntity)ent).addPotionEffect(effect, true);
                                continue;
                            }
                            catch (Exception ignored) {
                                // empty catch block
                            }
                        }
                        continue;
                    }
                    if (data[0].equalsIgnoreCase("v")) {
                        try {
                            String[] coords = COMMA_PATTERN.split(data[1]);
                            double x = Double.parseDouble(coords[0]);
                            double y = Double.parseDouble(coords[1]);
                            double z = Double.parseDouble(coords[2]);
                            ent.setVelocity(new org.bukkit.util.Vector(x, y, z));
                        }
                        catch (Exception ignored) {}
                        continue;
                    }
                    if (!data[0].equalsIgnoreCase("s") || !(ent instanceof LivingEntity)) continue;
                    byte d = 0;
                    String[] splitBit = SEMICOLON_PATTERN.split(bit);
                    String[] splitEvenMore = COLON_PATTERN.split(splitBit[0]);
                    try {
                        d = Byte.parseByte(splitEvenMore[2]);
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    ItemStack slot = new ItemStack(Integer.parseInt(splitEvenMore[1]), 1, (short)d);
                    try {
                        for (int e = 1; e < splitBit.length; ++e) {
                            String[] enchantInfo = COLON_PATTERN.split(splitBit[e]);
                            slot.addEnchantment(Enchantment.getById((int)Integer.parseInt(enchantInfo[0])), Integer.parseInt(enchantInfo[1]));
                        }
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    ((LivingEntity)ent).getEquipment().setItemInHand(slot);
                }
                if (upwards == null) {
                    if (BukkitUtil.toSign((ChangedSign)effectSign).getBlock().getRelative(0, 1, 0).getTypeId() == 68) {
                        effectSign = BukkitUtil.toChangedSign((Block)BukkitUtil.toSign((ChangedSign)effectSign).getBlock().getRelative(0, 1, 0));
                        upwards = true;
                        continue;
                    }
                    if (BukkitUtil.toSign((ChangedSign)effectSign).getBlock().getRelative(0, -1, 0).getTypeId() != 68) continue block14;
                    effectSign = BukkitUtil.toChangedSign((Block)BukkitUtil.toSign((ChangedSign)effectSign).getBlock().getRelative(0, -1, 0));
                    upwards = false;
                    continue;
                }
                if (BukkitUtil.toSign((ChangedSign)effectSign).getBlock().getRelative(0, upwards != false ? 1 : -1, 0).getTypeId() != 68) continue block14;
                effectSign = BukkitUtil.toChangedSign((Block)BukkitUtil.toSign((ChangedSign)effectSign).getBlock().getRelative(0, upwards != false ? 1 : -1, 0));
            }
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new AdvancedEntitySpawner(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Spawns a mob with many customizations.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"x:y:z", "entitytype*amount"};
            return lines;
        }
    }
}

