/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.entity;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.EnumUtil;
import com.sk89q.craftbook.util.LocationUtil;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.PoweredMinecart;
import org.bukkit.entity.StorageMinecart;
import org.bukkit.util.Vector;

public class EntityCannon
extends AbstractIC {
    public EntityCannon(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public String getTitle() {
        return "Entity Cannon";
    }

    public String getSignTitle() {
        return "ENTITY CANNON";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.shoot());
        }
    }

    protected boolean shoot() {
        boolean resultBoolean = false;
        Location location = BukkitUtil.toSign((ChangedSign)this.getSign()).getLocation();
        Type type = Type.MOB_HOSTILE;
        if (!this.getSign().getLine(3).isEmpty()) {
            type = Type.fromString(this.getSign().getLine(3));
        }
        try {
            for (Entity e : LocationUtil.getNearbyEntities((Location)location, (int)3)) {
                if (e.isDead() || !e.isValid() || !type.is(e)) continue;
                String[] split = ICUtil.COLON_PATTERN.split(this.getSign().getLine(2));
                double x = Double.parseDouble(split[0]);
                double y = Double.parseDouble(split[1]);
                double z = Double.parseDouble(split[2]);
                e.setVelocity(new Vector(x, y, z).add(e.getVelocity()));
                resultBoolean = true;
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return resultBoolean;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new EntityCannon(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Shoots nearby entities of type at set velocity.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"velocity x:y:z", "mob type"};
            return lines;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        PLAYER,
        MOB_HOSTILE,
        MOB_PEACEFUL,
        MOB_ANY,
        ANY,
        CART,
        CART_STORAGE,
        CART_POWERED,
        ITEM;


        public boolean is(Entity entity) {
            switch (this) {
                case PLAYER: {
                    return entity instanceof Player;
                }
                case MOB_HOSTILE: {
                    return entity instanceof Monster;
                }
                case MOB_PEACEFUL: {
                    return entity instanceof Animals;
                }
                case MOB_ANY: {
                    return entity instanceof Creature;
                }
                case CART: {
                    return entity instanceof Minecart;
                }
                case CART_STORAGE: {
                    return entity instanceof StorageMinecart;
                }
                case CART_POWERED: {
                    return entity instanceof PoweredMinecart;
                }
                case ITEM: {
                    return entity instanceof Item;
                }
                case ANY: {
                    return true;
                }
            }
            return false;
        }

        public static Type fromString(String name) {
            return (Type)EnumUtil.getEnumFromString(Type.class, (String)name);
        }
    }
}

