/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.entity;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.gates.world.entity.TeleportTransmitter;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.craftbook.util.Tuple2;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class TeleportReciever
extends AbstractIC {
    String band;
    String welcome;

    public TeleportReciever(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public String getTitle() {
        return "Teleport Reciever";
    }

    public String getSignTitle() {
        return "TELEPORT IN";
    }

    public void load() {
        this.band = this.getLine(2);
        this.welcome = this.getLine(3);
        if (this.welcome == null || this.welcome.isEmpty()) {
            this.welcome = "The Teleporter moves you here...";
        }
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.check();
        }
    }

    public void check() {
        Tuple2<Long, String> val = TeleportTransmitter.getValue(this.band);
        if (val == null) {
            return;
        }
        Player p = Bukkit.getServer().getPlayer((String)val.b);
        if (p == null || !p.isOnline()) {
            return;
        }
        p.teleport(SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()).getLocation().add(0.5, 1.5, 0.5));
        p.sendMessage(ChatColor.YELLOW + this.welcome);
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new TeleportReciever(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Reciever for the teleportation network.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"frequency name", "welcome text"};
            return lines;
        }
    }
}

