/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.items;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.bukkit.CircuitsPlugin;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.PipeInputIC;
import com.sk89q.craftbook.util.GeneralUtil;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.BlockWorldVector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.material.Dispenser;
import org.bukkit.material.PistonBaseMaterial;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutomaticCrafter
extends AbstractIC
implements PipeInputIC {
    private Recipe recipe = null;

    public AutomaticCrafter(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public String getTitle() {
        return "Automatic Crafter";
    }

    @Override
    public String getSignTitle() {
        return "AUTO CRAFT";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.doStuff(true, true));
        }
    }

    public boolean craft(org.bukkit.block.Dispenser disp) {
        PistonBaseMaterial p;
        Block b;
        Inventory inv = disp.getInventory();
        for (ItemStack it : inv.getContents()) {
            if (it == null || it.getTypeId() == 0 || it.getAmount() >= 2) continue;
            return false;
        }
        if (this.recipe == null) {
            Iterator recipes = Bukkit.recipeIterator();
            try {
                while (recipes.hasNext()) {
                    Recipe temprecipe = (Recipe)recipes.next();
                    if (!this.isValidRecipe(temprecipe, inv)) continue;
                    this.recipe = temprecipe;
                }
            }
            catch (Exception e) {
                Bukkit.getLogger().severe(GeneralUtil.getStackTrace((Throwable)e));
                disp.getInventory().setContents(inv.getContents());
            }
        }
        if (this.recipe == null) {
            return false;
        }
        if (!this.isValidRecipe(this.recipe, inv)) {
            this.recipe = null;
            this.craft(disp);
            return false;
        }
        ItemStack[] replace = new ItemStack[9];
        for (int i = 0; i < disp.getInventory().getContents().length; ++i) {
            if (disp.getInventory().getContents()[i] == null) continue;
            replace[i] = new ItemStack(disp.getInventory().getContents()[i]);
            replace[i].setAmount(replace[i].getAmount() - 1);
        }
        disp.getInventory().clear();
        boolean pipes = false;
        if (CircuitsPlugin.getInst().pipeFactory != null && (b = disp.getBlock().getRelative(((Dispenser)disp.getData()).getFacing())).getTypeId() == 29 && (p = (PistonBaseMaterial)b.getState().getData()).getFacing() == ((Dispenser)disp.getData()).getFacing().getOppositeFace()) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            items.add(this.recipe.getResult());
            if (CircuitsPlugin.getInst().pipeFactory != null && CircuitsPlugin.getInst().pipeFactory.detect(BukkitUtil.toWorldVector((Block)b), items) != null) {
                pipes = true;
            }
        }
        if (!pipes) {
            disp.getInventory().addItem(new ItemStack[]{this.recipe.getResult()});
            disp.dispense();
        }
        disp.getInventory().setContents(replace);
        return true;
    }

    public boolean collect(org.bukkit.block.Dispenser disp) {
        block0: for (Entity en : BukkitUtil.toSign((ChangedSign)this.getSign()).getChunk().getEntities()) {
            Item item;
            if (!(en instanceof Item) || !ItemUtil.isStackValid((ItemStack)(item = (Item)en).getItemStack()) || item.isDead() || !item.isValid()) continue;
            Location loc = item.getLocation();
            int ix = loc.getBlockX();
            int iy = loc.getBlockY();
            int iz = loc.getBlockZ();
            boolean delete = true;
            if (ix != this.getSign().getX() || iy != this.getSign().getY() || iz != this.getSign().getZ()) continue;
            int newAmount = item.getItemStack().getAmount();
            for (int i = 0; i < item.getItemStack().getAmount(); ++i) {
                ItemStack it = ItemUtil.getSmallestStackOfType((ItemStack[])disp.getInventory().getContents(), (ItemStack)item.getItemStack());
                if (it == null) continue block0;
                if (it.getAmount() < 64) {
                    it.setAmount(it.getAmount() + 1);
                    --newAmount;
                    continue;
                }
                if (newAmount <= 0) continue;
                delete = false;
                break;
            }
            item.getItemStack().setAmount(newAmount);
            if (newAmount > 0) {
                delete = false;
            }
            if (!delete) continue;
            item.remove();
        }
        return false;
    }

    public boolean doStuff(boolean craft, boolean collect) {
        boolean ret = false;
        Block crafter = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()).getRelative(0, 1, 0);
        if (crafter.getTypeId() == 23) {
            org.bukkit.block.Dispenser disp = (org.bukkit.block.Dispenser)crafter.getState();
            if (craft) {
                this.craft(disp);
            }
            if (collect) {
                this.collect(disp);
            }
        }
        return ret;
    }

    public boolean isValidRecipe(Recipe r, Inventory inv) {
        if (r instanceof ShapedRecipe && (this.recipe == null || this.recipe instanceof ShapedRecipe)) {
            boolean large;
            ShapedRecipe shape = (ShapedRecipe)r;
            Map ingredientMap = shape.getIngredientMap();
            String[] shapeArr = shape.getShape();
            boolean bl = large = shapeArr.length >= 3;
            if (this.recipe != null && ((ShapedRecipe)this.recipe).getShape().length != shapeArr.length) {
                return false;
            }
            int c = -1;
            int in = 0;
            for (ItemStack stack : inv.getContents()) {
                try {
                    String shapeSection;
                    Character item;
                    ItemStack require;
                    if (++c > (large ? 2 : 1)) {
                        c = 0;
                        if (++in > (large ? 2 : 1)) break;
                        if (!large) continue;
                    }
                    if (ItemUtil.areItemsIdentical((ItemStack)(require = (ItemStack)ingredientMap.get(item = Character.valueOf((shapeSection = shapeArr[in]).charAt(c)))), (ItemStack)stack)) continue;
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }
            return true;
        }
        if (r instanceof ShapelessRecipe && (this.recipe == null || this.recipe instanceof ShapelessRecipe)) {
            ShapelessRecipe shape = (ShapelessRecipe)r;
            ArrayList ing = new ArrayList();
            ing.addAll(shape.getIngredientList());
            block3: for (ItemStack it : inv.getContents()) {
                if (!ItemUtil.isStackValid((ItemStack)it)) continue;
                for (ItemStack stack : ing) {
                    if (stack == null || !ItemUtil.areItemsIdentical((ItemStack)it, (ItemStack)stack)) continue;
                    ing.remove(stack);
                    continue block3;
                }
            }
            return ing.isEmpty();
        }
        return false;
    }

    @Override
    public List<ItemStack> onPipeTransfer(BlockWorldVector pipe, List<ItemStack> items) {
        Block crafter = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()).getRelative(0, 1, 0);
        if (crafter.getTypeId() == 23) {
            org.bukkit.block.Dispenser disp = (org.bukkit.block.Dispenser)crafter.getState();
            boolean delete = true;
            ArrayList<ItemStack> newItems = new ArrayList<ItemStack>();
            newItems.addAll(items);
            for (ItemStack ite : items) {
                if (ite == null) continue;
                int iteind = items.indexOf(ite);
                int newAmount = ite.getAmount();
                for (int i = 0; i < ite.getAmount(); ++i) {
                    ItemStack it = ItemUtil.getSmallestStackOfType((ItemStack[])disp.getInventory().getContents(), (ItemStack)ite);
                    if (it == null) continue;
                    if (it.getAmount() < 64) {
                        it.setAmount(it.getAmount() + 1);
                        --newAmount;
                        continue;
                    }
                    if (newAmount <= 0) continue;
                    delete = false;
                    break;
                }
                if (newAmount > 0) {
                    delete = false;
                }
                ite.setAmount(newAmount);
                if (delete) {
                    newItems.remove(iteind);
                    continue;
                }
                newItems.set(iteind, ite);
            }
            items.clear();
            items.addAll(newItems);
        }
        return items;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new AutomaticCrafter(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Auto-crafts recipes in the above dispenser.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{null, null};
            return lines;
        }
    }
}

