/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.items;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.worldedit.Vector;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.inventory.ItemStack;

public class ChestStocker
extends AbstractIC {
    ItemStack item;
    Vector offset = new Vector(0, 2, 0);

    public ChestStocker(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public void load() {
        this.item = ICUtil.getItem(this.getLine(2));
        try {
            String[] loc = ICUtil.COLON_PATTERN.split(ICUtil.EQUALS_PATTERN.split(this.getSign().getLine(3))[1]);
            this.offset = new Vector(Integer.parseInt(loc[0]), Integer.parseInt(loc[1]), Integer.parseInt(loc[2]));
            if (this.offset.getX() > 16.0) {
                this.offset.setX(16);
            }
            if (this.offset.getY() > 16.0) {
                this.offset.setY(16);
            }
            if (this.offset.getZ() > 16.0) {
                this.offset.setZ(16);
            }
            if (this.offset.getX() < -16.0) {
                this.offset.setX(-16);
            }
            if (this.offset.getY() < -16.0) {
                this.offset.setY(-16);
            }
            if (this.offset.getZ() < -16.0) {
                this.offset.setZ(-16);
            }
        }
        catch (Exception e) {
            this.offset = new Vector(0, 2, 0);
        }
    }

    public String getTitle() {
        return "Chest Stocker";
    }

    public String getSignTitle() {
        return "STOCKER";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.stock());
        }
    }

    public boolean stock() {
        Block chest = BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock().getRelative(this.offset.getBlockX(), this.offset.getBlockY(), this.offset.getBlockZ());
        if (chest.getTypeId() == 54) {
            Chest c = (Chest)chest.getState();
            if (c.getInventory().addItem(new ItemStack[]{this.item.clone()}).isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new ChestStocker(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Adds item into above chest.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"item id:data", "x:y:z offset"};
            return lines;
        }
    }
}

