/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.miscellaneous;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;

public class ArrowShooter
extends AbstractIC {
    float speed = 1.6f;
    float spread = 12.0f;
    float vert = 0.2f;

    public ArrowShooter(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public void load() {
        try {
            String[] velocity = ICUtil.COLON_PATTERN.split(this.getSign().getLine(2).trim());
            this.speed = Float.parseFloat(velocity[0]);
            this.spread = Float.parseFloat(velocity[1]);
            this.vert = Float.parseFloat(this.getSign().getLine(3).trim());
        }
        catch (Exception e) {
            this.getSign().setLine(2, this.speed + ":" + this.spread + ":" + this.vert);
            this.getSign().update(false);
        }
        if ((double)this.speed > 10.0) {
            this.speed = 10.0f;
        } else if ((double)this.speed < 0.1) {
            this.speed = 0.1f;
        }
        if (this.spread > 5000.0f) {
            this.spread = 5000.0f;
        } else if (this.spread < 0.0f) {
            this.spread = 0.0f;
        }
        if (this.vert > 100.0f) {
            this.vert = 100.0f;
        } else if (this.vert < -100.0f) {
            this.vert = -100.0f;
        }
    }

    public String getTitle() {
        return "Arrow Shooter";
    }

    public String getSignTitle() {
        return "ARROW SHOOTER";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.shootArrows(1);
        }
    }

    public void shootArrows(int n) {
        Block signBlock = BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock();
        BlockFace face = SignUtil.getBack((Block)signBlock);
        Block targetDir = signBlock.getRelative(face).getRelative(face);
        float x = targetDir.getX() - signBlock.getX();
        float z = targetDir.getZ() - signBlock.getZ();
        Vector velocity = new Vector(x, this.vert, z);
        Location shootLoc = new Location(BukkitUtil.toSign((ChangedSign)this.getSign()).getWorld(), (double)targetDir.getX() + 0.5, (double)targetDir.getY() + 0.5, (double)targetDir.getZ() + 0.5);
        for (int i = 0; i < n; i = (int)((short)(i + 1))) {
            BukkitUtil.toSign((ChangedSign)this.getSign()).getWorld().spawnArrow(shootLoc, velocity, this.speed, this.spread);
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new ArrowShooter(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Shoots an arrow.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"speed:spread", "vertical gain"};
            return lines;
        }
    }
}

