/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.miscellaneous;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.ic.RestrictedIC;
import org.bukkit.Server;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionInducer
extends AbstractIC {
    int radius = 10;
    int effectID = 1;
    int effectAmount = 1;
    int effectTime = 10;
    boolean mobs = false;
    boolean players = true;

    public PotionInducer(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public String getTitle() {
        return "Potion Inducer";
    }

    public String getSignTitle() {
        return "POTION INDUCER";
    }

    public void load() {
        String[] effectInfo = ICUtil.COLON_PATTERN.split(this.getSign().getLine(2), 3);
        this.effectID = Integer.parseInt(effectInfo[0]);
        this.effectAmount = Integer.parseInt(effectInfo[1]);
        this.effectTime = Integer.parseInt(effectInfo[2]);
        String line4 = this.getSign().getLine(3);
        if (line4.contains("pm")) {
            this.mobs = true;
            this.players = true;
        } else if (line4.contains("m")) {
            this.mobs = true;
            this.players = false;
        } else if (line4.contains("p")) {
            this.players = true;
            this.mobs = false;
        }
        line4 = line4.replace("m", "").replace("p", "");
        try {
            this.radius = Integer.parseInt(line4);
        }
        catch (Exception e) {
            this.radius = 10;
        }
    }

    public void induce() {
        for (LivingEntity p : BukkitUtil.toSign((ChangedSign)this.getSign()).getWorld().getLivingEntities()) {
            if (!this.mobs && !(p instanceof Player) || !this.players && p instanceof Player || p.getLocation().distanceSquared(BukkitUtil.toSign((ChangedSign)this.getSign()).getLocation()) > (double)(this.radius * this.radius)) continue;
            p.addPotionEffect(new PotionEffect(PotionEffectType.getById((int)this.effectID), this.effectTime * 20, this.effectAmount - 1), true);
        }
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.induce();
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new PotionInducer(this.getServer(), sign, this);
        }

        public void verify(ChangedSign sign) throws ICVerificationException {
            try {
                int effectId = Integer.parseInt(ICUtil.COLON_PATTERN.split(sign.getLine(2), 2)[0]);
                if (PotionEffectType.getById((int)effectId) == null) {
                    throw new ICVerificationException("The third line must be a valid potion effect id.");
                }
            }
            catch (NumberFormatException e) {
                throw new ICVerificationException("The third line must be a valid potion effect id.");
            }
        }

        public String getDescription() {
            return "Gives nearby entities a potion effect.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"id:level:time", "range (add a m to the end to only induce mobs or p for players (pm for both))"};
            return lines;
        }
    }
}

