/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.miscellaneous;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.block.Block;

public class SoundEffect
extends AbstractIC {
    float volume;
    byte pitch;
    Sound sound;

    public SoundEffect(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public void load() {
        String[] split = ICUtil.COLON_PATTERN.split(this.getSign().getLine(2));
        this.volume = Float.parseFloat(split[0]) / 100.0f;
        try {
            this.pitch = (byte)((double)Integer.parseInt(split[1]) / 1.5873015873015872);
        }
        catch (Exception e) {
            this.pitch = 0;
        }
        String soundName = this.getSign().getLine(3).trim();
        this.sound = Sound.valueOf((String)soundName);
    }

    public String getTitle() {
        return "Sound Effect";
    }

    public String getSignTitle() {
        return "SOUND EFFECT";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.doSound();
        }
    }

    public void doSound() {
        try {
            Block b = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock());
            b.getWorld().playSound(b.getLocation(), this.sound, this.volume, (float)this.pitch);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new SoundEffect(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Plays a sound effect on high.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"volume:pitch", "sound name"};
            return lines;
        }
    }
}

