/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.miscellaneous;

import com.sk89q.craftbook.BaseConfiguration;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.util.HistoryHashMap;
import org.bukkit.Server;

public class WirelessTransmitter
extends AbstractIC {
    protected static final HistoryHashMap<String, Boolean> memory = new HistoryHashMap(100);
    protected String band;

    public WirelessTransmitter(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
        try {
            this.band = sign.getLine(2);
            this.band = this.band + sign.getLine(3);
        }
        catch (Exception e) {
            this.band = "test";
        }
    }

    public String getTitle() {
        return "Wireless Transmitter";
    }

    public String getSignTitle() {
        return "TRANSMITTER";
    }

    public void trigger(ChipState chip) {
        WirelessTransmitter.setValue(this.band, chip.getInput(0));
        chip.setOutput(0, chip.getInput(0));
    }

    public static Boolean getValue(String band) {
        return (Boolean)memory.get((Object)band);
    }

    public static void setValue(String band, boolean val) {
        memory.put((Object)band, (Object)val);
    }

    public static class Factory
    extends AbstractICFactory {
        public boolean requirename;

        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new WirelessTransmitter(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Transmits wireless signal to wireless recievers.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"wireless band", "user"};
            return lines;
        }

        public void checkPlayer(ChangedSign sign, LocalPlayer player) throws ICVerificationException {
            if (this.requirename) {
                sign.setLine(3, player.getName());
            } else if (!sign.getLine(3).isEmpty()) {
                sign.setLine(3, player.getName());
            }
        }

        public void addConfiguration(BaseConfiguration.BaseConfigurationSection section) {
            this.requirename = section.getBoolean("per-player", false);
        }

        public boolean needsConfiguration() {
            return true;
        }
    }
}

