/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.sensors;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.ICVerificationException;
import java.util.regex.Pattern;
import org.bukkit.Server;
import org.bukkit.block.Block;

public class BlockSensor
extends AbstractIC {
    private static final Pattern COLON_PATTERN = Pattern.compile(":", 16);
    private Block center;
    private int id = 0;
    private byte data = (byte)-1;

    public BlockSensor(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public void load() {
        String[] ids = COLON_PATTERN.split(this.getSign().getLine(3), 2);
        this.id = Integer.parseInt(ids[0]);
        try {
            this.data = Byte.parseByte(ids[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getTitle() {
        return "Block Sensor";
    }

    public String getSignTitle() {
        return "BLOCK SENSOR";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, !this.hasBlock());
        }
    }

    protected boolean hasBlock() {
        this.center = ICUtil.parseBlockLocation(this.getSign());
        int blockID = this.center.getTypeId();
        if (this.data != -1 && blockID == this.id) {
            return this.data == this.center.getData();
        }
        return blockID == this.id;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new BlockSensor(this.getServer(), sign, this);
        }

        public void verify(ChangedSign sign) throws ICVerificationException {
            try {
                String[] split = COLON_PATTERN.split(sign.getLine(3), 2);
                Integer.parseInt(split[0]);
            }
            catch (Exception ignored) {
                throw new ICVerificationException("You need to specify a block in line four.");
            }
            ICUtil.verifySignSyntax(sign);
        }

        public String getDescription() {
            return "Checks for blocks at location.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"x:y:z", "id:data"};
            return lines;
        }
    }
}

