/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.sensors;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.gates.world.sensors.BlockSensor;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.ic.SelfTriggeredIC;
import java.util.regex.Pattern;
import org.bukkit.Server;

public class BlockSensorST
extends BlockSensor
implements SelfTriggeredIC {
    private static final Pattern COLON_PATTERN = Pattern.compile(":", 16);

    public BlockSensorST(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public String getTitle() {
        return "Self-triggered Block Sensor";
    }

    public String getSignTitle() {
        return "ST BLOCK SENSOR";
    }

    public void think(ChipState chip) {
        chip.setOutput(0, !this.hasBlock());
    }

    public boolean isActive() {
        return true;
    }

    public static class Factory
    extends BlockSensor.Factory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new BlockSensorST(this.getServer(), sign, this);
        }

        public void verify(ChangedSign sign) throws ICVerificationException {
            try {
                String[] split = COLON_PATTERN.split(sign.getLine(3));
                Integer.parseInt(split[0]);
            }
            catch (Exception ignored) {
                throw new ICVerificationException("You need to specify an block in line four.");
            }
            ICUtil.verifySignSyntax(sign);
        }
    }
}

