/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.sensors;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.gates.world.sensors.EntitySensor;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.SignUtil;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;

public class MovementSensor
extends AbstractIC {
    private Set<EntitySensor.Type> types;
    private Block center;
    private Set<Chunk> chunks;
    private int radius;

    public MovementSensor(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public void load() {
        this.types = EntitySensor.Type.getDetected(this.getSign().getLine(3).trim());
        if (this.types.isEmpty()) {
            this.types.add(EntitySensor.Type.ANY);
        }
        this.getSign().setLine(3, this.getSign().getLine(3).toUpperCase());
        this.radius = ICUtil.parseRadius(this.getSign());
        if (this.getSign().getLine(2).contains("=")) {
            this.getSign().setLine(2, this.radius + "=" + ICUtil.EQUALS_PATTERN.split(this.getSign().getLine(2))[1]);
            this.center = ICUtil.parseBlockLocation(this.getSign());
        } else {
            this.getSign().setLine(2, String.valueOf(this.radius));
            this.center = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock());
        }
        this.chunks = LocationUtil.getSurroundingChunks((Block)SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()), (int)this.radius);
        this.getSign().update(false);
    }

    public String getTitle() {
        return "Movement Sensor";
    }

    public String getSignTitle() {
        return "MOVING SENSOR";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.check());
        }
    }

    public boolean check() {
        for (Chunk chunk : this.chunks) {
            if (!chunk.isLoaded()) continue;
            block1: for (Entity entity : chunk.getEntities()) {
                if (!entity.isValid()) continue;
                for (EntitySensor.Type type : this.types) {
                    if (!type.is(entity)) continue;
                    if (!LocationUtil.isWithinRadius((Location)this.center.getLocation(), (Location)entity.getLocation(), (int)this.radius) || !(entity.getVelocity().lengthSquared() >= 0.01)) continue block1;
                    return true;
                }
            }
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new MovementSensor(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Outputs high if a nearby entity is moving.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"radius=x:y:z offset", "entity type"};
            return lines;
        }
    }
}

