/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.sensors;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.bukkit.CircuitsPlugin;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.GeneralUtil;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class PlayerSensor
extends AbstractIC {
    int radius;
    Location location = null;
    ProtectedRegion reg = null;
    Type type = Type.PLAYER;
    String nameLine = "";

    public PlayerSensor(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    public String getTitle() {
        return "Player Detection";
    }

    public String getSignTitle() {
        return "P-DETECTION";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.isDetected());
        }
    }

    public void load() {
        this.radius = 10;
        this.location = BukkitUtil.toSign((ChangedSign)this.getSign()).getLocation();
        if (this.getLine(3).contains(":")) {
            this.type = Type.getFromChar(this.getLine(3).trim().toCharArray()[0]);
        }
        this.nameLine = this.getSign().getLine(3).replace("g:", "").replace("p:", "").trim();
        try {
            if (this.getLine(2).startsWith("r:") && CircuitsPlugin.getInst().getWorldGuard() != null) {
                String region = this.getLine(2).replace("r:", "");
                this.reg = CircuitsPlugin.getInst().getWorldGuard().getRegionManager(BukkitUtil.toSign((ChangedSign)this.getSign()).getWorld()).getRegion(region);
                if (this.reg != null) {
                    return;
                }
            }
            this.radius = ICUtil.parseRadius(this.getSign());
            if (this.getSign().getLine(2).contains("=")) {
                this.getSign().setLine(2, this.radius + 61 + ICUtil.EQUALS_PATTERN.split(this.getSign().getLine(2))[1]);
                this.location = ICUtil.parseBlockLocation(this.getSign()).getLocation();
            } else {
                this.getSign().setLine(2, String.valueOf(this.radius));
                this.location = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()).getLocation();
            }
        }
        catch (NullPointerException e) {
            Bukkit.getLogger().severe(GeneralUtil.getStackTrace((Throwable)e));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean isDetected() {
        block6: {
            Player p;
            block5: {
                if (this.reg == null) break block5;
                for (Player p2 : BukkitUtil.toSign((ChangedSign)this.getSign()).getWorld().getPlayers()) {
                    if (!this.reg.contains(p2.getLocation().getBlockX(), p2.getLocation().getBlockY(), p2.getLocation().getBlockZ())) continue;
                    return true;
                }
                break block6;
            }
            if (this.location == null) break block6;
            if (this.type == Type.PLAYER && (p = Bukkit.getPlayer((String)this.nameLine)) != null && LocationUtil.isWithinRadius((Location)this.location, (Location)p.getLocation(), (int)this.radius)) {
                return true;
            }
            for (Player e : this.getServer().getOnlinePlayers()) {
                if (e == null || !e.isValid() || !LocationUtil.isWithinRadius((Location)this.location, (Location)e.getLocation(), (int)this.radius)) continue;
                if (this.nameLine.isEmpty()) {
                    return true;
                }
                if (this.type == Type.PLAYER && e.getName().toLowerCase().startsWith(this.nameLine.toLowerCase())) {
                    return true;
                }
                if (this.type != Type.GROUP || !CircuitsPlugin.getInst().isInGroup(e.getName(), this.nameLine)) continue;
                return true;
            }
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new PlayerSensor(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Detects players within a radius.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"radius=x:y:z offset, or r:regionname for WorldGuard regions", "p:playername or g:permissiongroup"};
            return lines;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        PLAYER('p'),
        GROUP('g');

        char prefix;

        private Type(char prefix) {
            this.prefix = prefix;
        }

        public static Type getFromChar(char c) {
            c = Character.toLowerCase(c);
            for (Type t : Type.values()) {
                if (t.prefix != c) continue;
                return t;
            }
            return PLAYER;
        }
    }
}

