/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.weather;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.ic.SelfTriggeredIC;
import com.sk89q.craftbook.util.LocationUtil;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class TimeFaker
extends AbstractIC
implements SelfTriggeredIC {
    private ArrayList<String> players = new ArrayList();
    int dist;
    long time;

    public TimeFaker(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public String getTitle() {
        return "Time Faker";
    }

    public String getSignTitle() {
        return "TIME FAKER";
    }

    public void load() {
        this.dist = Integer.parseInt(this.getSign().getLine(2));
        this.time = Long.parseLong(this.getSign().getLine(3));
    }

    public boolean isActive() {
        return true;
    }

    public void trigger(ChipState chip) {
    }

    public void think(ChipState chip) {
        if (chip.getInput(0)) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!this.players.contains(p.getName()) && LocationUtil.isWithinRadius((Location)p.getLocation(), (Location)BukkitUtil.toSign((ChangedSign)this.getSign()).getLocation(), (int)this.dist)) {
                    p.setPlayerTime(this.time, false);
                    this.players.add(p.getName());
                    continue;
                }
                if (!this.players.contains(p.getName())) continue;
                p.resetPlayerTime();
                this.players.remove(p.getName());
            }
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new TimeFaker(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Radius based fake time.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"radius", "time"};
            return lines;
        }
    }
}

