/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.weather;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.RestrictedIC;
import org.bukkit.Server;

public class TimeSet
extends AbstractIC {
    long time;

    public TimeSet(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public String getTitle() {
        return "Time Set";
    }

    public String getSignTitle() {
        return "TIME SET";
    }

    public void load() {
        this.time = Long.parseLong(this.getSign().getLine(2));
    }

    public void trigger(ChipState chip) {
        try {
            if (chip.getInput(0)) {
                BukkitUtil.toSign((ChangedSign)this.getSign()).getWorld().setTime(this.time);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new TimeSet(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Set time when triggered.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"time to set", null};
            return lines;
        }
    }
}

