/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.weather;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import java.util.regex.Pattern;
import org.bukkit.Server;
import org.bukkit.World;

public class WeatherControl
extends AbstractIC {
    private static final Pattern RIGHT_BRACKET_PATTERN = Pattern.compile("]", 16);

    public WeatherControl(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public String getTitle() {
        return "Weather Control";
    }

    public String getSignTitle() {
        return "WEATHER CONTROL";
    }

    public void trigger(ChipState chip) {
        int duration;
        boolean tstorm = false;
        int thunderDuration = duration = 24000;
        try {
            String[] st = RIGHT_BRACKET_PATTERN.split(this.getSign().getLine(1), 2);
            if (st.length > 1) {
                tstorm = st[1].equalsIgnoreCase("t");
            }
            duration = Integer.parseInt(this.getSign().getLine(2));
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            thunderDuration = Integer.parseInt(this.getSign().getLine(3));
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (duration > 24000) {
            duration = 24000;
        }
        if (duration < 1) {
            duration = 1;
        }
        if (thunderDuration > 24000) {
            thunderDuration = 24000;
        }
        if (thunderDuration < 1) {
            thunderDuration = 1;
        }
        World world = BukkitUtil.toSign((ChangedSign)this.getSign()).getWorld();
        if (chip.getInput(0)) {
            world.setStorm(true);
            world.setWeatherDuration(duration);
            if (tstorm) {
                world.setThundering(true);
                world.setThunderDuration(thunderDuration);
            }
            chip.setOutput(0, true);
        } else {
            world.setThundering(false);
            world.setStorm(false);
            chip.setOutput(0, false);
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new WeatherControl(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Set rain and thunder duration.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"rain duration", "thunder duration"};
            return lines;
        }
    }
}

