/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.ic;

import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.bukkit.CircuitsPlugin;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICFamily;
import com.sk89q.craftbook.ic.ICManager;
import com.sk89q.craftbook.ic.ICMechanic;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.ic.RegisteredICFactory;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.ic.SelfTriggeredIC;
import com.sk89q.craftbook.ic.SelfTriggeredICMechanic;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.WorldVector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.block.Block;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICMechanicFactory
extends AbstractMechanicFactory<ICMechanic> {
    public static final Pattern IC_PATTERN = Pattern.compile("^\\[(([A-Z]{1,3})[0-9]{1,4})\\][A-Z]?$", 2);
    private static final Pattern RIGHT_BRACKET_PATTERN = Pattern.compile("]", 16);
    protected final ICManager manager;
    protected final CircuitsPlugin plugin;

    public ICMechanicFactory(CircuitsPlugin plugin, ICManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    public ICMechanic detect(BlockWorldVector pt) throws InvalidMechanismException {
        IC ic;
        Block block = BukkitUtil.toWorld((WorldVector)pt).getBlockAt(BukkitUtil.toLocation((WorldVector)pt));
        if (block.getTypeId() != 68) {
            return null;
        }
        ChangedSign sign = BukkitUtil.toChangedSign((Block)block);
        Matcher matcher = IC_PATTERN.matcher(sign.getLine(1));
        if (!matcher.matches()) {
            return null;
        }
        String prefix = matcher.group(2);
        if (prefix.equalsIgnoreCase("MCA")) {
            sign.setLine(1, sign.getLine(1).replace("A", "") + "A");
            sign.update(false);
        }
        if (!this.manager.hasCustomPrefix(prefix)) {
            return null;
        }
        String id = matcher.group(1);
        RegisteredICFactory registration = this.manager.get(id);
        if (registration == null) {
            throw new InvalidMechanismException("\"" + sign.getLine(1) + "\" should be an IC ID, but no IC registered under that ID could be found.");
        }
        if (ICManager.isCachedIC(pt)) {
            ic = ICManager.getCachedIC(pt);
        } else {
            ic = registration.getFactory().create(sign);
            ICManager.addCachedIC(pt, ic);
        }
        String suffix = "";
        String[] str = RIGHT_BRACKET_PATTERN.split(sign.getLine(1));
        if (str.length > 1) {
            suffix = str[1];
        }
        ICFamily family = registration.getFamilies()[0];
        if (suffix != null && !suffix.isEmpty()) {
            for (ICFamily f : registration.getFamilies()) {
                if (!f.getSuffix().equalsIgnoreCase(suffix)) continue;
                family = f;
                break;
            }
        }
        if (ic instanceof SelfTriggeredIC) {
            return new SelfTriggeredICMechanic(this.plugin, id, (SelfTriggeredIC)ic, family, pt);
        }
        return new ICMechanic(this.plugin, id, ic, family, pt);
    }

    public ICMechanic detect(BlockWorldVector pt, LocalPlayer player, ChangedSign sign) throws InvalidMechanismException {
        return this.detect(pt, player, sign, false);
    }

    private ICMechanic detect(BlockWorldVector pt, LocalPlayer player, ChangedSign sign, boolean shortHand) throws InvalidMechanismException {
        Block block = BukkitUtil.toWorld((WorldVector)pt).getBlockAt(BukkitUtil.toLocation((WorldVector)pt));
        boolean matches = true;
        Matcher matcher = IC_PATTERN.matcher(sign.getLine(1));
        if (!matcher.matches()) {
            matches = false;
        }
        try {
            if (!this.manager.hasCustomPrefix(matcher.group(2))) {
                matches = false;
            }
        }
        catch (Exception e) {
            matches = false;
        }
        if (matches) {
            RegisteredICFactory registration;
            String id = matcher.group(1);
            String suffix = "";
            String[] str = RIGHT_BRACKET_PATTERN.split(sign.getLine(1));
            if (str.length > 1) {
                suffix = str[1];
            }
            if (block.getTypeId() != 68) {
                throw new InvalidMechanismException("Only wall signs are used for ICs.");
            }
            if (ICManager.isCachedIC(pt)) {
                ICManager.removeCachedIC(pt);
            }
            if ((registration = this.manager.get(id)) == null) {
                throw new InvalidMechanismException("Unknown IC detected: " + id);
            }
            ICFactory factory = registration.getFactory();
            this.checkPermissions(player, factory, id, registration);
            factory.verify(sign);
            factory.checkPlayer(sign, player);
            IC ic = registration.getFactory().create(sign);
            sign.setLine(1, "[" + registration.getId() + "]" + suffix);
            ICFamily family = registration.getFamilies()[0];
            if (suffix != null && !suffix.isEmpty()) {
                for (ICFamily f : registration.getFamilies()) {
                    if (!f.getSuffix().equalsIgnoreCase(suffix)) continue;
                    family = f;
                    break;
                }
            }
            ICMechanic mechanic = ic instanceof SelfTriggeredIC ? new SelfTriggeredICMechanic(this.plugin, id, (SelfTriggeredIC)ic, family, pt) : new ICMechanic(this.plugin, id, ic, family, pt);
            if (!shortHand) {
                sign.setLine(0, ic.getSignTitle());
            }
            player.print("You've created " + registration.getId() + ": " + ic.getTitle() + ".");
            return mechanic;
        }
        if (this.plugin.getLocalConfiguration().enableShorthandIcs && sign.getLine(0).startsWith("=")) {
            String id = sign.getLine(0).substring(1);
            if (block.getTypeId() != 68) {
                throw new InvalidMechanismException("Only wall signs are used for ICs.");
            }
            String shortId = this.manager.longRegistered.get(id.toLowerCase());
            if (shortId == null) {
                player.printError("Warning: Unknown IC");
                return null;
            }
            sign.setLine(1, "[" + shortId + "]");
            this.detect(pt, player, sign, true);
        }
        return null;
    }

    public boolean checkPermissions(LocalPlayer player, ICFactory factory, String id, RegisteredICFactory registration) throws ICVerificationException {
        if (player.hasPermission("craftbook.ic." + factory.getClass().getPackage().getName())) {
            return true;
        }
        if (player.hasPermission("craftbook.ic." + id.toLowerCase())) {
            return true;
        }
        if (factory instanceof RestrictedIC ? !player.hasPermission("craftbook.ic.restricted." + id.toLowerCase()) : !player.hasPermission("craftbook.ic.safe." + id.toLowerCase())) {
            throw new ICVerificationException("You don't have permission to use " + registration.getId() + ".");
        }
        return true;
    }
}

