/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.ic;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.blocks.BlockType;
import com.sk89q.worldedit.blocks.ItemType;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Lever;

public class ICUtil {
    public static final Pattern EQUALS_PATTERN = Pattern.compile("=", 16);
    public static final Pattern COLON_PATTERN = Pattern.compile(":", 16);
    private static HashMap<Location, Boolean> torchStatus = new HashMap();

    public static Boolean getTorchStatus(Location loc) {
        return torchStatus.get(loc);
    }

    public static void removeTorch(Location loc) {
        torchStatus.remove(loc);
    }

    public static void setTorch(Location loc, Boolean value) {
        torchStatus.put(loc, value);
    }

    public static boolean setState(Block block, boolean state, Block source) {
        if (block.getTypeId() != 69) {
            return false;
        }
        Lever lever = (Lever)block.getState().getData();
        if (!block.getRelative(lever.getAttachedFace()).equals(source)) {
            return false;
        }
        boolean wasOn = (block.getData() & 8) > 0;
        byte data = block.getData();
        int newData = !state ? data & 7 : data | 8;
        if (wasOn != state) {
            block.setData((byte)newData, true);
            block.setData(block.getData(), true);
            return true;
        }
        return false;
    }

    public static Block parseBlockLocation(ChangedSign sign, int lPos, boolean relative) {
        String[] split;
        Block target = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)sign).getBlock());
        String line = sign.getLine(lPos);
        int offsetX = 0;
        int offsetY = 0;
        int offsetZ = 0;
        if (line.contains("=")) {
            split = EQUALS_PATTERN.split(line);
            line = split[1];
        }
        try {
            split = COLON_PATTERN.split(line);
            if (split.length > 1) {
                offsetX = Integer.parseInt(split[0]);
                offsetY = Integer.parseInt(split[1]);
                offsetZ = Integer.parseInt(split[2]);
            } else {
                offsetY = Integer.parseInt(line);
            }
        }
        catch (NumberFormatException e) {
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        target = relative ? LocationUtil.getRelativeOffset((ChangedSign)sign, (int)offsetX, (int)offsetY, (int)offsetZ) : LocationUtil.getOffset((Block)target, (int)offsetX, (int)offsetY, (int)offsetZ);
        return target;
    }

    public static Block parseBlockLocation(ChangedSign sign, int lPos) {
        return ICUtil.parseBlockLocation(sign, lPos, true);
    }

    public static Block parseBlockLocation(ChangedSign sign) {
        return ICUtil.parseBlockLocation(sign, 2, true);
    }

    public static void verifySignSyntax(ChangedSign sign) throws ICVerificationException {
        ICUtil.verifySignSyntax(sign, 2);
    }

    public static void verifySignSyntax(ChangedSign sign, int i) throws ICVerificationException {
        try {
            String[] strings;
            String line = sign.getLine(i);
            if (line.contains("=")) {
                String[] split = EQUALS_PATTERN.split(line, 2);
                Integer.parseInt(split[0]);
                strings = COLON_PATTERN.split(split[1], 3);
            } else {
                strings = COLON_PATTERN.split(line);
            }
            if (strings.length > 1) {
                Integer.parseInt(strings[1]);
                Integer.parseInt(strings[2]);
            }
            Integer.parseInt(strings[0]);
        }
        catch (Exception e) {
            throw new ICVerificationException("Wrong syntax! Needs to be: radius=x:y:z or radius=y or y");
        }
    }

    public static int parseRadius(ChangedSign sign) {
        return ICUtil.parseRadius(sign, 2);
    }

    public static int parseRadius(ChangedSign sign, int lPos) {
        String line = sign.getLine(lPos);
        int radius = 10;
        try {
            return Integer.parseInt(EQUALS_PATTERN.split(line, 2)[0]);
        }
        catch (NumberFormatException e) {
            return radius;
        }
    }

    public static ItemStack getItem(String line) {
        if (line.isEmpty()) {
            return null;
        }
        try {
            if (line.contains(":")) {
                String[] split = COLON_PATTERN.split(line, 2);
                int id = 0;
                int data = 0;
                try {
                    id = Integer.parseInt(split[0]);
                    data = Integer.parseInt(split[1]);
                }
                catch (NumberFormatException e) {
                    try {
                        id = BlockType.lookup((String)split[0]).getID();
                        if (id < 0) {
                            throw new NullPointerException();
                        }
                    }
                    catch (Exception ee) {
                        id = ItemType.lookup((String)split[0]).getID();
                    }
                    data = Integer.parseInt(split[1]);
                }
                return new ItemStack(id, 1, (short)data);
            }
            int id = 0;
            try {
                id = Integer.parseInt(line);
            }
            catch (NumberFormatException e) {
                try {
                    id = BlockType.lookup((String)line).getID();
                    if (id < 0) {
                        throw new NullPointerException();
                    }
                }
                catch (Exception ee) {
                    id = ItemType.lookup((String)line).getID();
                }
            }
            return new ItemStack(id, 1, 0);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

