/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.jinglenote;

import com.sk89q.craftbook.jinglenote.JingleSequencer;
import com.sk89q.craftbook.util.GeneralUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class JingleNotePlayer
implements Runnable {
    protected final Player player;
    protected final Location loc;
    protected JingleSequencer sequencer;
    protected final int delay;

    public JingleNotePlayer(Player player, Location loc, JingleSequencer seq, int delay) {
        this.player = player;
        this.loc = loc;
        this.sequencer = seq;
        this.delay = delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (this.delay > 0) {
                Thread.sleep(this.delay);
            }
            try {
                this.sequencer.run(this);
            }
            catch (Throwable t) {
                Bukkit.getLogger().severe(GeneralUtil.getStackTrace((Throwable)t));
            }
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            Bukkit.getLogger().severe(GeneralUtil.getStackTrace((Throwable)e));
        }
        finally {
            this.sequencer.stop();
            this.sequencer = null;
        }
    }

    public boolean isActive() {
        return this.player.isOnline();
    }

    public Player getPlayer() {
        return this.player;
    }

    public Location getLocation() {
        return this.loc;
    }

    public void stop(boolean keepMusicBlock) {
        if (this.sequencer != null) {
            this.sequencer.stop();
        }
    }

    public void play(Sound instrument, int pitch) {
        if (!this.player.isOnline() || instrument == null) {
            return;
        }
        float np = (float)Math.pow(2.0, (double)(pitch - 12) / 12.0);
        this.player.playSound(this.loc, instrument, 30.0f, np);
    }

    public void play(Sound instrument, int pitch, float velocity) {
        if (!this.player.isOnline() || instrument == null) {
            return;
        }
        float np = (float)Math.pow(2.0, (double)(pitch - 12) / 12.0);
        this.player.playSound(this.player.getLocation(), instrument, velocity / 64.0f, np);
    }
}

