/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.plc;

import com.sk89q.craftbook.BaseConfiguration;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.bukkit.BaseBukkitPlugin;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.plc.PlcIC;
import com.sk89q.craftbook.plc.PlcLanguage;
import java.util.regex.Pattern;
import org.bukkit.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlcFactory<StateT, CodeT, Lang extends PlcLanguage<StateT, CodeT>>
implements ICFactory {
    private static final Pattern PLC_NAME_PATTERN = Pattern.compile("[-_a-z0-9]+", 2);
    private Lang lang;
    private boolean selfTriggered;
    private Server s;

    public PlcFactory(Server s, Lang lang, boolean selfTriggered) {
        this.s = s;
        this.lang = lang;
        this.selfTriggered = selfTriggered;
    }

    @Override
    public IC create(ChangedSign sign) {
        PlcIC i = new PlcIC(this.s, sign, this.lang);
        return this.selfTriggered ? i.selfTriggered() : i;
    }

    @Override
    public void verify(ChangedSign sign) throws ICVerificationException {
        String line;
        new PlcIC(sign, this.lang);
        sign.setLine(2, "id:" + Math.abs(BaseBukkitPlugin.random.nextInt()));
        if (!sign.getLine(3).isEmpty() && !PLC_NAME_PATTERN.matcher(line = sign.getLine(3)).matches()) {
            throw new ICVerificationException("illegal storage name");
        }
        sign.update(false);
    }

    @Override
    public void checkPlayer(ChangedSign sign, LocalPlayer player) throws ICVerificationException {
    }

    public static <StateT, CodeT, Lang extends PlcLanguage<StateT, CodeT>> PlcFactory<StateT, CodeT, Lang> fromLang(Server s, Lang lang, boolean selfTriggered) {
        return new PlcFactory<StateT, CodeT, Lang>(s, lang, selfTriggered);
    }

    @Override
    public String getDescription() {
        return "Programmable Logic Chip";
    }

    @Override
    public String[] getLineHelp() {
        return new String[]{"", ""};
    }

    @Override
    public void addConfiguration(BaseConfiguration.BaseConfigurationSection section) {
    }

    @Override
    public boolean needsConfiguration() {
        return false;
    }
}

