/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.plc;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.ic.SelfTriggeredIC;
import com.sk89q.craftbook.plc.CodeNotFoundException;
import com.sk89q.craftbook.plc.PlcException;
import com.sk89q.craftbook.plc.PlcLanguage;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.LocalWorld;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PlcIC<StateT, CodeT, Lang extends PlcLanguage<StateT, CodeT>>
implements IC {
    private static final Logger logger = Logger.getLogger("Minecraft.CraftBook");
    private static final int PLC_STORE_VERSION = 1;
    private Lang lang;
    private StateT state;
    private String codeString;
    private CodeT code;
    private ChangedSign sign;
    private boolean error = false;
    private String errorString = "no error";

    PlcIC(ChangedSign s, Lang l) throws ICVerificationException {
        this.sign = s;
        try {
            this.codeString = this.getCode();
        }
        catch (CodeNotFoundException e) {
            throw new ICVerificationException("Error retrieving code: " + e.getMessage());
        }
        l.compile(this.codeString);
    }

    public PlcIC(Server sv, ChangedSign s, Lang l) {
        this.lang = l;
        this.sign = s;
        if (s == null) {
            return;
        }
        try {
            this.codeString = this.getCode();
        }
        catch (CodeNotFoundException e) {
            this.error("code missing", "Code went missing!!");
        }
        try {
            if (this.codeString != null) {
                this.code = this.lang.compile(this.codeString);
            }
        }
        catch (ICVerificationException e) {
            throw new RuntimeException("inconsistent compile check!", (Throwable)((Object)e));
        }
        this.state = this.lang.initState();
        this.tryLoadState();
    }

    private boolean isShared() {
        return !this.sign.getLine(3).isEmpty() && this.sign.getLine(3).startsWith("id:");
    }

    private String getID() {
        return this.sign.getLine(2);
    }

    private String getFileName() {
        if (!this.isShared()) {
            BlockWorldVector l = this.sign.getBlockVector();
            return this.lang.getName() + "$$" + l.getBlockX() + "_" + l.getBlockY() + "_" + l.getBlockZ();
        }
        return this.lang.getName() + "$" + this.sign.getLine(3);
    }

    private File getStorageLocation() {
        World w = BukkitUtil.toWorld((LocalWorld)this.sign.getLocalWorld());
        File worldDir = w.getWorldFolder();
        File targetDir = new File(worldDir, "craftbook-plcs");
        targetDir.mkdirs();
        return new File(targetDir, this.getFileName());
    }

    private String hashCode(String code) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(code.getBytes("UTF-8"));
            StringBuilder hex = new StringBuilder();
            for (byte aDigest : digest) {
                String byteHex = Integer.toHexString(aDigest & 0xFF);
                if (byteHex.length() == 1) {
                    hex.append("0");
                }
                hex.append(byteHex);
            }
            return hex.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("insane JVM implementation", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("insane JVM implementation", e);
        }
    }

    private void tryLoadState() {
        try {
            this.loadState();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to load PLC state", e);
            this.state = this.lang.initState();
            this.getStorageLocation().delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadState() throws IOException {
        if (!this.getStorageLocation().exists()) {
            return;
        }
        DataInputStream in = new DataInputStream(new FileInputStream(this.getStorageLocation()));
        try {
            switch (in.readInt()) {
                case 1: {
                    this.error = in.readBoolean();
                    this.errorString = in.readUTF();
                }
                case 0: {
                    String langName = in.readUTF();
                    String id = in.readUTF();
                    String code = this.hashCode(in.readUTF());
                    if ((this.lang.getName().equals(langName) || this.lang.supports(langName)) && (this.isShared() || id.equals(this.getID()) && this.hashCode(this.codeString).equals(code))) {
                        this.lang.loadState(this.state, in);
                        return;
                    } else {
                        this.error = false;
                        this.errorString = "no error";
                        return;
                    }
                }
                default: {
                    throw new IOException("incompatible version");
                }
            }
        }
        finally {
            in.close();
        }
    }

    private void trySaveState() {
        try {
            this.saveState();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to save PLC state", e);
            this.state = this.lang.initState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveState() throws IOException {
        DataOutputStream out = new DataOutputStream(new FileOutputStream(this.getStorageLocation()));
        try {
            out.writeInt(1);
            out.writeBoolean(this.error);
            out.writeUTF(this.errorString);
            out.writeUTF(this.lang.getName());
            out.writeUTF(this.error ? "(error)" : this.getID());
            out.writeUTF(this.hashCode(this.codeString));
            this.lang.writeState(this.state, out);
        }
        finally {
            out.close();
        }
    }

    private String getBookCode(Block chestBlock) throws CodeNotFoundException {
        Chest c = (Chest)chestBlock.getState();
        Inventory i = c.getBlockInventory();
        ItemStack book = null;
        for (ItemStack s : i.getContents()) {
            if (s == null || s.getAmount() <= 0 || s.getTypeId() != 386 && s.getTypeId() != 387) continue;
            if (book != null) {
                throw new CodeNotFoundException("More than one written book found in chest!!");
            }
            book = s;
        }
        if (book == null) {
            throw new CodeNotFoundException("No written books found in chest.");
        }
        StringBuilder code = new StringBuilder();
        for (String s : ((BookMeta)book.getItemMeta()).getPages()) {
            code.append(s).append("\n");
        }
        System.out.println(code);
        return code.toString();
    }

    private String getCode() throws CodeNotFoundException {
        Sign sign = BukkitUtil.toSign((ChangedSign)this.sign);
        Block above = sign.getLocation().add(new Vector(0, 1, 0)).getBlock();
        if (above.getTypeId() == 54) {
            return this.getBookCode(above);
        }
        Block below = sign.getLocation().add(new Vector(0, -1, 0)).getBlock();
        if (below.getTypeId() == 54) {
            return this.getBookCode(below);
        }
        Location l = sign.getLocation();
        World w = l.getWorld();
        int x = l.getBlockX();
        int z = l.getBlockZ();
        for (int y = 0; y < w.getMaxHeight(); ++y) {
            Sign s;
            if (y == l.getBlockY() || !(w.getBlockAt(x, y, z).getState() instanceof Sign) || !(s = (Sign)w.getBlockAt(x, y, z).getState()).getLine(1).equalsIgnoreCase("[Code Block]")) continue;
            BlockState b = w.getBlockAt(x, --y, z).getState();
            StringBuilder code = new StringBuilder();
            while (b instanceof Sign) {
                s = (Sign)b;
                for (int li = 0; li < 4 && y != l.getBlockY(); ++li) {
                    code.append(s.getLine(li)).append("\n");
                }
                b = w.getBlockAt(x, --y, z).getState();
            }
            return code.toString();
        }
        throw new CodeNotFoundException("No code source found.");
    }

    @Override
    public String getTitle() {
        return this.lang.getName() + " PLC";
    }

    @Override
    public String getSignTitle() {
        return this.lang.getName().toUpperCase();
    }

    public void error(String shortMessage, String detailedMessage) {
        this.sign.setLine(2, ChatColor.RED + "!Error!");
        this.sign.setLine(3, shortMessage);
        this.sign.update(false);
        this.error = true;
        this.errorString = detailedMessage;
        this.trySaveState();
    }

    @Override
    public void trigger(ChipState chip) {
        try {
            if (this.isShared()) {
                this.tryLoadState();
            }
            this.lang.execute(chip, this.state, this.code);
            this.trySaveState();
        }
        catch (PlcException e) {
            this.error(e.getMessage(), e.detailedMessage);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Internal error while executing PLC", e);
            this.error(e.getClass().getName(), "Internal error encountered: " + e.getClass().getName());
        }
    }

    public IC selfTriggered() {
        final PlcIC self = this;
        return new SelfTriggeredIC(){

            public String getTitle() {
                return self.getTitle();
            }

            public String getSignTitle() {
                return self.getSignTitle();
            }

            public void trigger(ChipState chip) {
            }

            public void think(ChipState chip) {
                self.trigger(chip);
            }

            public boolean isActive() {
                return true;
            }

            public void onRightClick(Player p) {
                self.onRightClick(p);
            }

            public void unload() {
            }

            public void load() {
            }
        };
    }

    @Override
    public void onRightClick(Player p) {
        if (p.hasPermission("craftbook.plc.debug")) {
            p.sendMessage(ChatColor.GREEN + "Programmable Logic Controller debug information");
            BlockWorldVector l = this.sign.getBlockVector();
            p.sendMessage(ChatColor.RED + "Status:" + ChatColor.RESET + " " + (this.error ? "Error Encountered" : "OK"));
            p.sendMessage(ChatColor.RED + "Location:" + ChatColor.RESET + " (" + l.getBlockX() + ", " + l.getBlockY() + ", " + l.getBlockZ() + ")");
            p.sendMessage(ChatColor.RED + "Language:" + ChatColor.RESET + " " + this.lang.getName());
            p.sendMessage(ChatColor.RED + "Full Storage Name:" + ChatColor.RESET + " " + this.getFileName());
            if (this.error) {
                p.sendMessage(this.errorString);
            } else {
                p.sendMessage(this.lang.dumpState(this.state));
            }
        } else {
            p.sendMessage(ChatColor.RED + "You do not have the necessary permissions to do that.");
        }
    }

    @Override
    public void unload() {
    }

    @Override
    public void load() {
    }
}

