/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.bukkit;

import com.sk89q.craftbook.LanguageManager;
import com.sk89q.craftbook.Mechanic;
import com.sk89q.craftbook.MechanicFactory;
import com.sk89q.craftbook.MechanicManager;
import com.sk89q.craftbook.MechanismsConfiguration;
import com.sk89q.craftbook.bukkit.BaseBukkitPlugin;
import com.sk89q.craftbook.bukkit.MechanicClock;
import com.sk89q.craftbook.bukkit.MechanicListenerAdapter;
import com.sk89q.craftbook.bukkit.Metrics;
import com.sk89q.craftbook.bukkit.commands.MechanismCommands;
import com.sk89q.craftbook.mech.AIMechanic;
import com.sk89q.craftbook.mech.Ammeter;
import com.sk89q.craftbook.mech.Bookcase;
import com.sk89q.craftbook.mech.Bridge;
import com.sk89q.craftbook.mech.Cauldron;
import com.sk89q.craftbook.mech.Chair;
import com.sk89q.craftbook.mech.ChunkAnchor;
import com.sk89q.craftbook.mech.Command;
import com.sk89q.craftbook.mech.CookingPot;
import com.sk89q.craftbook.mech.CustomDrops;
import com.sk89q.craftbook.mech.Door;
import com.sk89q.craftbook.mech.Elevator;
import com.sk89q.craftbook.mech.Gate;
import com.sk89q.craftbook.mech.HiddenSwitch;
import com.sk89q.craftbook.mech.LightStone;
import com.sk89q.craftbook.mech.LightSwitch;
import com.sk89q.craftbook.mech.MapChanger;
import com.sk89q.craftbook.mech.PaintingSwitch;
import com.sk89q.craftbook.mech.Payment;
import com.sk89q.craftbook.mech.Snow;
import com.sk89q.craftbook.mech.Teleporter;
import com.sk89q.craftbook.mech.XPStorer;
import com.sk89q.craftbook.mech.area.Area;
import com.sk89q.craftbook.mech.area.CopyManager;
import com.sk89q.craftbook.mech.cauldron.ImprovedCauldron;
import com.sk89q.craftbook.mech.crafting.CustomCrafting;
import com.sk89q.craftbook.mech.dispenser.DispenserRecipes;
import com.sk89q.craftbook.mech.dispenser.Recipe;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MechanismsPlugin
extends BaseBukkitPlugin {
    protected MechanismsConfiguration config;
    private final CopyManager copyManager = new CopyManager();
    private MechanicManager manager;
    public static Economy economy = null;
    private DispenserRecipes dRecipes = null;
    private static MechanismsPlugin instance;

    public void onEnable() {
        instance = this;
        super.onEnable();
        this.registerCommand(MechanismCommands.class);
        this.createDefaultConfiguration("books.txt", false);
        this.createDefaultConfiguration("cauldron-recipes.txt", false);
        this.createDefaultConfiguration("config.yml", false);
        this.createDefaultConfiguration("custom-mob-drops.txt", false);
        this.createDefaultConfiguration("custom-block-drops.txt", false);
        this.createDefaultConfiguration("recipes.txt", false);
        this.createDefaultConfiguration("cauldron-recipes.yml", false);
        this.createDefaultConfiguration("crafting-recipes.yml", false);
        this.config = new MechanismsConfiguration(this.getConfig(), this.getDataFolder());
        this.saveConfig();
        this.setupEconomy();
        this.manager = new MechanicManager((BaseBukkitPlugin)this);
        MechanicListenerAdapter adapter = new MechanicListenerAdapter((BaseBukkitPlugin)this);
        adapter.register(this.manager);
        this.registerMechanics();
        this.registerEvents();
        this.languageManager = new LanguageManager((BaseBukkitPlugin)this);
        try {
            Metrics metrics = new Metrics((Plugin)this);
            Metrics.Graph graph = metrics.createGraph("Language");
            for (String lan : this.languageManager.getLanguages()) {
                graph.addPlotter(new Metrics.Plotter(lan){

                    public int getValue() {
                        return 1;
                    }
                });
            }
            metrics.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerMechanics() {
        if (this.getLocalConfiguration().ammeterSettings.enable) {
            this.registerMechanic((MechanicFactory<? extends Mechanic>)new Ammeter.Factory(this));
        }
        if (this.getLocalConfiguration().bookcaseSettings.enable) {
            this.registerMechanic((MechanicFactory<? extends Mechanic>)new Bookcase.Factory(this));
        }
        if (this.getLocalConfiguration().gateSettings.enable) {
            this.registerMechanic((MechanicFactory<? extends Mechanic>)new Gate.Factory(this));
        }
        if (this.getLocalConfiguration().bridgeSettings.enable) {
            this.registerMechanic((MechanicFactory<? extends Mechanic>)new Bridge.Factory(this));
        }
        if (this.getLocalConfiguration().doorSettings.enable) {
            this.registerMechanic((MechanicFactory<? extends Mechanic>)new Door.Factory(this));
        }
        if (this.getLocalConfiguration().elevatorSettings.enable) {
            this.registerMechanic((MechanicFactory<? extends Mechanic>)new Elevator.Factory(this));
        }
        if (this.getLocalConfiguration().teleporterSettings.enable) {
            this.registerMechanic((MechanicFactory<? extends Mechanic>)new Teleporter.Factory(this));
        }
        if (this.getLocalConfiguration().areaSettings.enable) {
            this.registerMechanic((MechanicFactory<? extends Mechanic>)new Area.Factory(this));
        }
        if (this.getLocalConfiguration().commandSettings.enable) {
            this.registerMechanic((MechanicFactory<? extends Mechanic>)new Command.Factory(this));
        }
        if (this.getLocalConfiguration().anchorSettings.enable) {
            this.registerMechanic((MechanicFactory<? extends Mechanic>)new ChunkAnchor.Factory(this));
        }
        if (this.getLocalConfiguration().lightStoneSettings.enable) {
            this.registerMechanic((MechanicFactory<? extends Mechanic>)new LightStone.Factory(this));
        }
        if (this.getLocalConfiguration().lightSwitchSettings.enable) {
            this.registerMechanic((MechanicFactory<? extends Mechanic>)new LightSwitch.Factory(this));
        }
        if (this.getLocalConfiguration().hiddenSwitchSettings.enable) {
            this.registerMechanic((MechanicFactory<? extends Mechanic>)new HiddenSwitch.Factory(this));
        }
        if (this.getLocalConfiguration().cookingPotSettings.enable) {
            this.registerMechanic((MechanicFactory<? extends Mechanic>)new CookingPot.Factory(this));
        }
        if (this.getLocalConfiguration().cauldronSettings.enable) {
            this.registerMechanic((MechanicFactory<? extends Mechanic>)new Cauldron.Factory(this));
        }
        if (this.getLocalConfiguration().cauldronSettings.enableNew) {
            this.registerMechanic((MechanicFactory<? extends Mechanic>)new ImprovedCauldron.Factory(this));
        }
        if (this.getLocalConfiguration().xpStorerSettings.enabled) {
            this.registerMechanic((MechanicFactory<? extends Mechanic>)new XPStorer.Factory(this));
        }
        if (this.getLocalConfiguration().mapChangerSettings.enabled) {
            this.registerMechanic((MechanicFactory<? extends Mechanic>)new MapChanger.Factory(this));
        }
        if (this.getLocalConfiguration().customCraftingSettings.enable) {
            new CustomCrafting(this);
        }
        if (economy != null && this.getLocalConfiguration().paymentSettings.enabled) {
            this.registerMechanic((MechanicFactory<? extends Mechanic>)new Payment.Factory(this));
        }
        this.setupSelfTriggered(this.manager);
    }

    private void setupSelfTriggered(MechanicManager manager) {
        logger.info("CraftBook: Enumerating chunks for INSTANCE-triggered components...");
        long start = System.currentTimeMillis();
        int numWorlds = 0;
        int numChunks = 0;
        for (World world : this.getServer().getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                manager.enumerate(chunk);
                ++numChunks;
            }
            ++numWorlds;
        }
        long time = System.currentTimeMillis() - start;
        logger.info("CraftBook: " + numChunks + " chunk(s) for " + numWorlds + " world(s) processed " + "(" + Math.round((double)time / 1000.0 * 10.0) / 10L + "s elapsed)");
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new MechanicClock(manager), 0L, 2L);
    }

    protected void registerEvents() {
        if (this.getLocalConfiguration().dispenserSettings.enable) {
            this.dRecipes = new DispenserRecipes(this);
            this.getServer().getPluginManager().registerEvents((Listener)this.dRecipes, (Plugin)this);
        }
        if (this.getLocalConfiguration().snowSettings.enable || this.getLocalConfiguration().snowSettings.placeSnow) {
            this.getServer().getPluginManager().registerEvents((Listener)new Snow(this), (Plugin)this);
        }
        if (this.getLocalConfiguration().customDropSettings.enable) {
            this.getServer().getPluginManager().registerEvents((Listener)new CustomDrops(this), (Plugin)this);
        }
        if (this.getLocalConfiguration().aiSettings.enabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new AIMechanic(this), (Plugin)this);
        }
        if (this.getLocalConfiguration().chairSettings.enable) {
            if (this.getProtocolManager() != null) {
                this.getServer().getPluginManager().registerEvents((Listener)new Chair(this), (Plugin)this);
            } else {
                this.getLogger().severe("Chairs require ProtocolLib! They will not function without it!");
            }
        }
        if (this.getLocalConfiguration().paintingSettings.enabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new PaintingSwitch(this), (Plugin)this);
        }
    }

    public MechanismsConfiguration getLocalConfiguration() {
        return this.config;
    }

    public CopyManager getCopyManager() {
        return this.copyManager;
    }

    private boolean setupEconomy() {
        try {
            RegisteredServiceProvider economyProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
            if (economyProvider != null) {
                economy = (Economy)economyProvider.getProvider();
            }
            return economy != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static MechanismsPlugin getInst() {
        return instance;
    }

    private void registerMechanic(MechanicFactory<? extends Mechanic> factory) {
        this.manager.register(factory);
    }

    private void registerMechanic(MechanicFactory<? extends Mechanic>[] factories) {
        for (MechanicFactory<? extends Mechanic> aFactory : factories) {
            this.registerMechanic(aFactory);
        }
    }

    private boolean unregisterMechanic(MechanicFactory<? extends Mechanic> factory) {
        return this.manager.unregister(factory);
    }

    private boolean unregisterAllMechanics() {
        boolean ret = true;
        for (MechanicFactory factory : this.manager.factories) {
            if (this.unregisterMechanic((MechanicFactory<? extends Mechanic>)factory)) continue;
            ret = false;
        }
        return ret;
    }

    public boolean registerDispenserRecipe(Recipe recipe) {
        return this.getLocalConfiguration().dispenserSettings.enable && this.dRecipes.addRecipe(recipe);
    }

    public void reloadConfiguration() {
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            public void run() {
                MechanismsPlugin.this.unregisterAllMechanics();
                HandlerList.unregisterAll((Plugin)MechanismsPlugin.getInst());
                MechanismsPlugin.this.reloadConfig();
                MechanismsPlugin.this.config = new MechanismsConfiguration(MechanismsPlugin.this.getConfig(), MechanismsPlugin.this.getDataFolder());
                MechanismsPlugin.this.saveConfig();
                MechanismsPlugin.this.registerMechanics();
                MechanismsPlugin.this.registerEvents();
            }
        });
    }
}

