/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.blocks.BlockType;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.event.player.PlayerInteractEvent;

public class Ammeter
extends AbstractMechanic {
    protected final MechanismsPlugin plugin;

    public Ammeter(MechanismsPlugin plugin) {
        this.plugin = plugin;
    }

    public void onRightClick(PlayerInteractEvent event) {
        LocalPlayer player = this.plugin.wrap(event.getPlayer());
        if (!player.hasPermission("craftbook.mech.ammeter.use")) {
            return;
        }
        Block block = event.getClickedBlock();
        if (event.getPlayer().getItemInHand().getTypeId() == this.plugin.getLocalConfiguration().ammeterSettings.id && (BlockType.canTransferRedstone((int)block.getTypeId()) || BlockType.isRedstoneSource((int)block.getTypeId()))) {
            int data = this.getSpecialData(block);
            String line = this.getCurrentLine(data);
            player.print("Ammeter: " + line + ChatColor.WHITE + " " + data + " A");
        }
    }

    private int getSpecialData(Block block) {
        int typeId = block.getTypeId();
        int data = block.getData();
        int current = 0;
        switch (typeId) {
            case 55: {
                current = data;
                break;
            }
            case 69: 
            case 77: {
                if ((data & 8) != 8) break;
                current = 15;
                break;
            }
            case 70: {
                if ((data & 1) != 1) break;
                current = 15;
                break;
            }
            case 27: 
            case 28: {
                if (data < 8) break;
                current = 15;
                break;
            }
            case 76: 
            case 94: {
                current = 15;
                break;
            }
            default: {
                current = 0;
            }
        }
        return current;
    }

    private String getCurrentLine(int data) {
        int i;
        StringBuilder line = new StringBuilder(25);
        line.append(ChatColor.YELLOW).append("[");
        if (data > 10) {
            line.append(ChatColor.DARK_GREEN);
        } else if (data > 5) {
            line.append(ChatColor.GOLD);
        } else if (data > 0) {
            line.append(ChatColor.DARK_RED);
        }
        for (i = 0; i < data; ++i) {
            line.append("|");
        }
        line.append(ChatColor.BLACK);
        for (i = data; i < 15; ++i) {
            line.append("|");
        }
        line.append(ChatColor.YELLOW).append("]");
        return line.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<Ammeter> {
        protected final MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        public Ammeter detect(BlockWorldVector pt) {
            Block block = BukkitUtil.toWorld((WorldVector)pt).getBlockAt(BukkitUtil.toLocation((WorldVector)pt));
            if (BlockType.canTransferRedstone((int)block.getTypeId()) || BlockType.isRedstoneSource((int)block.getTypeId())) {
                return new Ammeter(this.plugin);
            }
            return null;
        }
    }
}

