/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.MechanismsConfiguration;
import com.sk89q.craftbook.ProcessedMechanismException;
import com.sk89q.craftbook.SourcedBlockRedstoneEvent;
import com.sk89q.craftbook.bukkit.BaseBukkitPlugin;
import com.sk89q.craftbook.bukkit.BukkitPlayer;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.regions.CuboidRegion;
import org.bukkit.GameMode;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Bridge
extends AbstractMechanic {
    private MechanismsPlugin plugin;
    private MechanismsConfiguration.BridgeSettings settings;
    private Block trigger;
    private Block proximalBaseCenter;
    private Block farSide;
    private CuboidRegion toggle;

    private Bridge(Block trigger, MechanismsPlugin plugin) throws InvalidMechanismException {
        int i;
        int right;
        int left;
        String otherSignText;
        if (!SignUtil.isCardinal((Block)trigger)) {
            throw new InvalidDirectionException();
        }
        BlockFace dir = SignUtil.getFacing((Block)trigger);
        this.trigger = trigger;
        this.plugin = plugin;
        this.settings = plugin.getLocalConfiguration().bridgeSettings;
        this.proximalBaseCenter = trigger.getRelative(BlockFace.UP);
        int mat = this.proximalBaseCenter.getTypeId();
        if (!this.settings.canUseBlock(mat) || !this.isValidBridge(this.proximalBaseCenter, mat, BukkitUtil.toChangedSign((Block)trigger))) {
            this.proximalBaseCenter = trigger.getRelative(BlockFace.DOWN);
            mat = this.proximalBaseCenter.getTypeId();
            if (this.settings.canUseBlock(mat)) {
                if (!this.isValidBridge(this.proximalBaseCenter, mat, BukkitUtil.toChangedSign((Block)trigger))) {
                    throw new InvalidConstructionException("mech.bridge.material");
                }
            } else {
                throw new UnacceptableMaterialException("mech.bridge.unusable");
            }
        }
        this.farSide = trigger.getRelative(dir);
        for (int i2 = 0; i2 <= this.settings.maxLength && (this.farSide.getTypeId() != 63 || !"[Bridge]".equalsIgnoreCase(otherSignText = BukkitUtil.toChangedSign((Block)this.farSide).getLine(1)) && !"[Bridge End]".equalsIgnoreCase(otherSignText)); ++i2) {
            this.farSide = this.farSide.getRelative(dir);
        }
        if (this.farSide.getTypeId() != 63) {
            throw new InvalidConstructionException("mech.bridge.other-sign");
        }
        Block distalBaseCenter = this.farSide.getRelative(trigger.getFace(this.proximalBaseCenter));
        if (distalBaseCenter.getTypeId() != mat && distalBaseCenter.getData() != this.proximalBaseCenter.getData() || distalBaseCenter.getRelative(SignUtil.getLeft((Block)trigger)).getTypeId() != mat && distalBaseCenter.getRelative(SignUtil.getLeft((Block)trigger)).getData() != this.proximalBaseCenter.getData() || distalBaseCenter.getRelative(SignUtil.getRight((Block)trigger)).getTypeId() != mat && distalBaseCenter.getRelative(SignUtil.getRight((Block)trigger)).getData() != this.proximalBaseCenter.getData()) {
            throw new InvalidConstructionException("mech.bridge.material");
        }
        this.toggle = new CuboidRegion((Vector)BukkitUtil.toVector((Block)this.proximalBaseCenter), (Vector)BukkitUtil.toVector((Block)distalBaseCenter));
        try {
            left = Integer.parseInt(BukkitUtil.toChangedSign((Block)trigger).getLine(2));
            if (left < 0) {
                left = 0;
            }
        }
        catch (Exception ignored) {
            left = 1;
        }
        try {
            right = Integer.parseInt(BukkitUtil.toChangedSign((Block)trigger).getLine(3));
            if (right < 0) {
                right = 0;
            }
        }
        catch (Exception ignored) {
            right = 1;
        }
        if (left > this.settings.maxWidth) {
            left = this.settings.maxWidth;
        }
        if (right > this.settings.maxWidth) {
            right = this.settings.maxWidth;
        }
        for (i = 0; i < left; ++i) {
            this.toggle.expand(new Vector[]{BukkitUtil.toVector((BlockFace)SignUtil.getLeft((Block)trigger)), new Vector(0, 0, 0)});
        }
        for (i = 0; i < right; ++i) {
            this.toggle.expand(new Vector[]{BukkitUtil.toVector((BlockFace)SignUtil.getRight((Block)trigger)), new Vector(0, 0, 0)});
        }
        this.toggle.contract(new Vector[]{BukkitUtil.toVector((BlockFace)SignUtil.getBack((Block)trigger)), BukkitUtil.toVector((BlockFace)SignUtil.getFront((Block)trigger))});
    }

    public void onRightClick(PlayerInteractEvent event) {
        if (!this.plugin.getLocalConfiguration().bridgeSettings.enable) {
            return;
        }
        if (!BukkitUtil.toWorldVector((Block)event.getClickedBlock()).equals((Object)BukkitUtil.toWorldVector((Block)this.trigger))) {
            return;
        }
        BukkitPlayer player = new BukkitPlayer((BaseBukkitPlugin)this.plugin, event.getPlayer());
        if (!player.hasPermission("craftbook.mech.bridge.use")) {
            player.printError("mech.use-permission");
            return;
        }
        ChangedSign sign = null;
        if (event.getClickedBlock().getTypeId() == 63 || event.getClickedBlock().getTypeId() == 68) {
            sign = BukkitUtil.toChangedSign((Block)event.getClickedBlock());
        }
        if (sign != null && !sign.getLine(0).equalsIgnoreCase("infinite") && event.getPlayer().getItemInHand() != null && this.getBridgeMaterial() == event.getPlayer().getItemInHand().getTypeId()) {
            int amount = 1;
            if (event.getPlayer().isSneaking() && event.getPlayer().getItemInHand().getAmount() >= 5) {
                amount = 5;
            }
            this.addBlocks(sign, amount);
            if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                if (event.getPlayer().getItemInHand().getAmount() <= amount) {
                    event.getPlayer().setItemInHand(new ItemStack(0, 0));
                } else {
                    event.getPlayer().getItemInHand().setAmount(event.getPlayer().getItemInHand().getAmount() - amount);
                }
            }
            player.print("mech.restock");
            event.setCancelled(true);
            return;
        }
        this.flipState((LocalPlayer)player);
        event.setCancelled(true);
        player.print("mech.bridge.toggle");
    }

    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!this.plugin.getLocalConfiguration().bridgeSettings.enableRedstone) {
            return;
        }
        if (!BukkitUtil.toWorldVector((Block)event.getBlock()).equals((Object)BukkitUtil.toWorldVector((Block)this.trigger))) {
            return;
        }
        if (event.getNewCurrent() == event.getOldCurrent()) {
            return;
        }
        if (event.getNewCurrent() == 0) {
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new ToggleRegionOpen(), 2L);
        } else {
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new ToggleRegionClosed(null), 2L);
        }
    }

    private void flipState(LocalPlayer player) {
        Block hinge = this.proximalBaseCenter.getRelative(SignUtil.getFacing((Block)this.trigger));
        if (Bridge.canPassThrough(hinge.getTypeId())) {
            new ToggleRegionClosed(player).run();
        } else {
            new ToggleRegionOpen().run();
        }
    }

    private int getBridgeMaterial() {
        return this.proximalBaseCenter.getTypeId();
    }

    private byte getBridgeData() {
        return this.proximalBaseCenter.getData();
    }

    public boolean isValidBridge(Block baseCenter, int mat, ChangedSign s) throws InvalidMechanismException {
        if (!s.getLine(2).equals("0") ? this.proximalBaseCenter.getRelative(SignUtil.getLeft((Block)this.trigger)).getTypeId() != mat : this.proximalBaseCenter.getTypeId() != mat) {
            return false;
        }
        return !(!s.getLine(3).equals("0") ? this.proximalBaseCenter.getRelative(SignUtil.getRight((Block)this.trigger)).getTypeId() != mat : this.proximalBaseCenter.getTypeId() != mat);
    }

    private static boolean canPassThrough(int t) {
        int[] passableBlocks = new int[]{8, 9, 10, 11, 85, 78, 31, 106, 32, 0};
        for (int aPassableBlock : passableBlocks) {
            if (aPassableBlock != t) continue;
            return true;
        }
        return false;
    }

    public void onBlockBreak(BlockBreakEvent event) {
        ChangedSign sign = null;
        if (event.getBlock().getTypeId() == 68 || event.getBlock().getTypeId() == 63) {
            sign = BukkitUtil.toChangedSign((Block)event.getBlock());
        }
        if (sign == null) {
            return;
        }
        if (this.hasEnoughBlocks(sign)) {
            ItemStack toDrop = new ItemStack(this.getBridgeMaterial(), this.getBlocks(sign), (short)this.getBridgeData());
            BukkitUtil.toWorld((LocalWorld)sign.getLocalWorld()).dropItemNaturally(BukkitUtil.toLocation((WorldVector)sign.getBlockVector()), toDrop);
        }
    }

    public boolean removeBlocks(ChangedSign s, int amount) {
        if (s.getLine(0).equalsIgnoreCase("infinite")) {
            return true;
        }
        int curBlocks = this.getBlocks(s) - amount;
        s.setLine(0, String.valueOf(curBlocks));
        s.update(false);
        return curBlocks >= 0;
    }

    public boolean addBlocks(ChangedSign s, int amount) {
        if (s.getLine(0).equalsIgnoreCase("infinite")) {
            return true;
        }
        int curBlocks = this.getBlocks(s) + amount;
        s.setLine(0, String.valueOf(curBlocks));
        s.update(false);
        return curBlocks >= 0;
    }

    public int getBlocks(ChangedSign s) {
        int curBlocks;
        if (s.getLine(0).equalsIgnoreCase("infinite")) {
            return 0;
        }
        try {
            curBlocks = Integer.parseInt(s.getLine(0));
        }
        catch (NumberFormatException e) {
            curBlocks = 0;
        }
        return curBlocks;
    }

    public boolean hasEnoughBlocks(ChangedSign s) {
        return s.getLine(0).equalsIgnoreCase("infinite") || this.getBlocks(s) > 0;
    }

    private static class InvalidConstructionException
    extends InvalidMechanismException {
        private static final long serialVersionUID = 8758644926222590049L;

        public InvalidConstructionException(String msg) {
            super(msg);
        }
    }

    private static class UnacceptableMaterialException
    extends InvalidMechanismException {
        private static final long serialVersionUID = -2856504362189922160L;

        public UnacceptableMaterialException(String msg) {
            super(msg);
        }
    }

    private static class InvalidDirectionException
    extends InvalidMechanismException {
        private static final long serialVersionUID = -8169241147023551662L;

        private InvalidDirectionException() {
        }
    }

    private class ToggleRegionClosed
    implements Runnable {
        final LocalPlayer player;

        public ToggleRegionClosed(LocalPlayer player) {
            this.player = player;
        }

        public void run() {
            for (BlockVector bv : Bridge.this.toggle) {
                Block b = Bridge.this.trigger.getWorld().getBlockAt(bv.getBlockX(), bv.getBlockY(), bv.getBlockZ());
                if (!Bridge.canPassThrough(b.getTypeId())) continue;
                if (((Bridge)Bridge.this).plugin.getLocalConfiguration().mechSettings.stopDestruction) {
                    ChangedSign s = BukkitUtil.toChangedSign((Block)Bridge.this.trigger);
                    if (Bridge.this.hasEnoughBlocks(s)) {
                        b.setTypeId(Bridge.this.getBridgeMaterial());
                        b.setData(Bridge.this.getBridgeData());
                        Bridge.this.removeBlocks(s, 1);
                        continue;
                    }
                    if (this.player != null) {
                        this.player.printError("Not enough blocks for mechanic to function!");
                    }
                    return;
                }
                b.setTypeId(Bridge.this.getBridgeMaterial());
                b.setData(Bridge.this.getBridgeData());
            }
        }
    }

    private class ToggleRegionOpen
    implements Runnable {
        private ToggleRegionOpen() {
        }

        public void run() {
            for (BlockVector bv : Bridge.this.toggle) {
                Block b = Bridge.this.trigger.getWorld().getBlockAt(bv.getBlockX(), bv.getBlockY(), bv.getBlockZ());
                int oldType = b.getTypeId();
                if (b.getTypeId() != Bridge.this.getBridgeMaterial() && !Bridge.canPassThrough(b.getTypeId())) continue;
                b.setTypeId(0);
                if (!((Bridge)Bridge.this).plugin.getLocalConfiguration().mechSettings.stopDestruction) continue;
                ChangedSign s = BukkitUtil.toChangedSign((Block)Bridge.this.trigger);
                if (oldType == 0) continue;
                Bridge.this.addBlocks(s, 1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<Bridge> {
        private final MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        public Bridge detect(BlockWorldVector pt) throws InvalidMechanismException {
            Block block = BukkitUtil.toBlock((BlockWorldVector)pt);
            if (block.getTypeId() != 63) {
                return null;
            }
            if (!BukkitUtil.toChangedSign((Block)block).getLine(1).equalsIgnoreCase("[Bridge]")) {
                return null;
            }
            return new Bridge(block, this.plugin);
        }

        public Bridge detect(BlockWorldVector pt, LocalPlayer player, ChangedSign sign) throws InvalidMechanismException, ProcessedMechanismException {
            if (sign.getLine(1).equalsIgnoreCase("[Bridge]")) {
                player.checkPermission("craftbook.mech.bridge");
                sign.setLine(1, "[Bridge]");
                if (sign.getLine(0).equalsIgnoreCase("infinite") && !player.hasPermission("craftbook.mech.bridge.infinite")) {
                    sign.setLine(0, "0");
                } else if (!sign.getLine(0).equalsIgnoreCase("infinite")) {
                    sign.setLine(0, "0");
                }
                sign.update(false);
                player.print("mech.bridge.create");
            } else if (sign.getLine(1).equalsIgnoreCase("[Bridge End]")) {
                player.checkPermission("craftbook.mech.bridge");
                sign.setLine(1, "[Bridge End]");
                if (sign.getLine(0).equalsIgnoreCase("infinite") && !player.hasPermission("craftbook.mech.bridge.infinite")) {
                    sign.setLine(0, "0");
                } else if (!sign.getLine(0).equalsIgnoreCase("infinite")) {
                    sign.setLine(0, "0");
                }
                sign.update(false);
                player.print("mech.bridge.end-create");
            } else {
                return null;
            }
            throw new ProcessedMechanismException();
        }
    }
}

