/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.InsufficientPermissionsException;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.PersistentMechanic;
import com.sk89q.craftbook.ProcessedMechanismException;
import com.sk89q.craftbook.SelfTriggeringMechanic;
import com.sk89q.craftbook.SourcedBlockRedstoneEvent;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookingPot
extends PersistentMechanic
implements SelfTriggeringMechanic {
    protected final MechanismsPlugin plugin;
    protected final BlockWorldVector pt;

    public CookingPot(BlockWorldVector pt, MechanismsPlugin plugin) {
        this.pt = pt;
        this.plugin = plugin;
    }

    public boolean isActive() {
        return true;
    }

    public void think() {
        Block block = BukkitUtil.toWorld((WorldVector)this.pt).getBlockAt(BukkitUtil.toLocation((WorldVector)this.pt));
        if (block.getState() instanceof Sign) {
            Sign sign = (Sign)block.getState();
            int lastTick = 0;
            try {
                lastTick = Integer.parseInt(sign.getLine(2));
            }
            catch (Exception e) {
                sign.setLine(2, String.valueOf(lastTick));
                sign.update();
            }
            int oldTick = lastTick;
            if (lastTick < 0) {
                lastTick = 0;
            }
            Block b = SignUtil.getBackBlock((Block)sign.getBlock());
            int x = b.getX();
            int y = b.getY() + 2;
            int z = b.getZ();
            Block cb = sign.getWorld().getBlockAt(x, y, z);
            if (cb.getTypeId() == 54) {
                Block fire;
                if (ItemUtil.containsRawFood((Inventory)((Chest)cb.getState()).getInventory()) || ItemUtil.containsRawMinerals((Inventory)((Chest)cb.getState()).getInventory()) && this.plugin.getLocalConfiguration().cookingPotSettings.cooksOres) {
                    this.decreaseMultiplier(sign, 1);
                    lastTick += this.getMultiplier(sign);
                }
                if (lastTick >= 50 && (fire = sign.getWorld().getBlockAt(x, y - 1, z)).getTypeId() == 51) {
                    Chest chest = (Chest)cb.getState();
                    for (ItemStack i : chest.getInventory().getContents()) {
                        if (i == null) continue;
                        ItemStack cooked = ItemUtil.getCookedResult((ItemStack)i);
                        if (cooked == null) {
                            if (this.plugin.getLocalConfiguration().cookingPotSettings.cooksOres) {
                                cooked = ItemUtil.getSmeletedResult((ItemStack)i);
                            }
                            if (cooked == null) continue;
                        }
                        if (chest.getInventory().addItem(new ItemStack[]{cooked}).isEmpty()) {
                            chest.getInventory().removeItem(new ItemStack[]{new ItemStack(i.getType(), 1, i.getDurability())});
                        }
                        chest.update();
                        break;
                    }
                    lastTick = 0;
                }
            }
            if (lastTick != oldTick) {
                sign.setLine(2, String.valueOf(lastTick));
                sign.update();
            }
        }
    }

    public void onRightClick(PlayerInteractEvent event) {
        if (event.getClickedBlock().getState() instanceof Sign) {
            Sign sign = (Sign)event.getClickedBlock().getState();
            Block b = SignUtil.getBackBlock((Block)sign.getBlock());
            int x = b.getX();
            int y = b.getY() + 2;
            int z = b.getZ();
            Block cb = sign.getWorld().getBlockAt(x, y, z);
            if (cb.getTypeId() == 54) {
                Player player = event.getPlayer();
                ItemStack itemInHand = player.getItemInHand();
                if (itemInHand != null && Ingredients.isIngredient(itemInHand.getTypeId()) && itemInHand.getAmount() > 0) {
                    this.increaseMultiplier(sign, Ingredients.getTime(itemInHand.getTypeId()));
                    if (itemInHand.getAmount() <= 1) {
                        itemInHand.setTypeId(0);
                        player.setItemInHand(null);
                    } else {
                        itemInHand.setAmount(itemInHand.getAmount() - 1);
                    }
                    player.sendMessage("You give the pot fuel!");
                } else if (this.plugin.getLocalConfiguration().cookingPotSettings.openClick) {
                    player.openInventory(((Chest)cb.getState()).getBlockInventory());
                }
            }
        }
    }

    public void onLeftClick(PlayerInteractEvent event) {
        event.getPlayer().setFireTicks(20);
        LocalPlayer player = this.plugin.wrap(event.getPlayer());
        player.printError("mech.cook.ouch");
    }

    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        Block block = event.getBlock();
        if (block.getState() instanceof Sign) {
            Sign sign = (Sign)block.getState();
            try {
                if (event.getNewCurrent() > event.getOldCurrent()) {
                    this.increaseMultiplier(sign, 1);
                }
                sign.update();
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
    }

    public void setMultiplier(Sign sign, int amount) {
        int min;
        int n = min = this.plugin.getLocalConfiguration().cookingPotSettings.requiresfuel ? 0 : 1;
        if (amount < min) {
            amount = min;
        }
        sign.setLine(3, String.valueOf(amount));
        sign.update();
    }

    public void increaseMultiplier(Sign sign, int amount) {
        this.setMultiplier(sign, this.getMultiplier(sign) + amount);
    }

    public void decreaseMultiplier(Sign sign, int amount) {
        this.setMultiplier(sign, this.getMultiplier(sign) - amount);
    }

    public int getMultiplier(Sign sign) {
        int multiplier;
        try {
            multiplier = Integer.parseInt(sign.getLine(3));
        }
        catch (Exception e) {
            multiplier = 1;
            if (this.plugin.getLocalConfiguration().cookingPotSettings.requiresfuel) {
                multiplier = 0;
            }
            this.setMultiplier(sign, multiplier);
        }
        if (multiplier < 0) {
            return this.plugin.getLocalConfiguration().cookingPotSettings.requiresfuel ? 0 : 1;
        }
        return multiplier;
    }

    public List<BlockWorldVector> getWatchedPositions() {
        ArrayList<BlockWorldVector> bwv = new ArrayList<BlockWorldVector>();
        bwv.add(this.pt);
        return bwv;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Ingredients {
        COAL(263, 10),
        LAVA(327, 500),
        BLAZE(369, 200),
        SNOWBALL(332, -20),
        SNOW(80, -100);

        private int id;
        private int mult;

        private Ingredients(int id, int mult) {
            this.id = id;
            this.mult = mult;
        }

        public static boolean isIngredient(int id) {
            for (Ingredients in : Ingredients.values()) {
                if (in.id != id) continue;
                return true;
            }
            return false;
        }

        public static int getTime(int id) {
            for (Ingredients in : Ingredients.values()) {
                if (in.id != id) continue;
                return in.mult;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<CookingPot> {
        protected final MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        public CookingPot detect(BlockWorldVector pt) {
            Sign sign;
            BlockState state;
            Block block = BukkitUtil.toWorld((WorldVector)pt).getBlockAt(BukkitUtil.toLocation((WorldVector)pt));
            if (block.getTypeId() == 68 && (state = block.getState()) instanceof Sign && (sign = (Sign)state).getLine(1).equalsIgnoreCase("[Cook]")) {
                sign.update();
                return new CookingPot(pt, this.plugin);
            }
            return null;
        }

        public CookingPot detect(BlockWorldVector pt, LocalPlayer player, ChangedSign sign) throws InvalidMechanismException, ProcessedMechanismException {
            if (sign.getLine(1).equalsIgnoreCase("[Cook]")) {
                if (!player.hasPermission("craftbook.mech.cook")) {
                    throw new InsufficientPermissionsException();
                }
                sign.setLine(2, "0");
                sign.setLine(1, "[Cook]");
                if (this.plugin.getLocalConfiguration().cookingPotSettings.requiresfuel) {
                    sign.setLine(3, "0");
                } else {
                    sign.setLine(3, "1");
                }
            } else {
                return null;
            }
            sign.update(false);
            player.print("mech.cook.create");
            throw new ProcessedMechanismException();
        }
    }
}

