/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.craftbook.util.GeneralUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.block.Furnace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

@Deprecated
public class CustomCrafting
implements Listener {
    private static final Pattern COMMENT_PATTERN = Pattern.compile("#", 16);
    private static final Pattern COLON_PATTERN = Pattern.compile(":", 16);
    private static final Pattern COMMA_PATTERN = Pattern.compile(",", 16);
    private static final Pattern X_PATTERN = Pattern.compile("x", 16);
    private static final Pattern LEFT_BRACKET_PATTERN = Pattern.compile("[", 16);
    private static final Pattern AT_LEFT_BRACKET_PATTERN = Pattern.compile("@[", 16);
    private static final Pattern DOLLAR_LEFT_BRACKET_PATTERN = Pattern.compile("$[", 16);
    private static final Pattern AMPERSAND_LEFT_BRACKET_PATTERN = Pattern.compile("&[", 16);
    private static final Pattern ASTERISK_LEFT_BRACKET_PATTERN = Pattern.compile("*[", 16);
    final MechanismsPlugin plugin;
    public final HashMap<Integer, Integer> fuels = new HashMap();

    public CustomCrafting(MechanismsPlugin plugin) {
        this.plugin = plugin;
        this.addRecipes();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onClick(InventoryClickEvent event) {
        if (event.getInventory() instanceof FurnaceInventory) {
            if (this.fuels == null || this.fuels.size() <= 0) {
                return;
            }
            FurnaceInventory inv = (FurnaceInventory)event.getInventory();
            if (event.getSlot() == 1 && inv.getHolder().getBurnTime() < 1 && inv.getItem(1) != null && this.fuels.get(inv.getItem(1).getTypeId()) > 0) {
                inv.getHolder().setBurnTime(this.fuels.get(inv.getItem(1).getTypeId()).shortValue());
                inv.getItem(1).setAmount(inv.getItem(1).getAmount() - 1);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onFurnaceBurn(FurnaceBurnEvent event) {
        if (event.getFuel() == null) {
            return;
        }
        if (event.getBurnTime() > 0) {
            return;
        }
        Furnace f = (Furnace)event.getBlock().getState();
        if (f.getInventory().getSmelting() != null) {
            return;
        }
        if (f.getInventory().getItem(0) != null) {
            return;
        }
        if (this.fuels.get(event.getFuel().getTypeId()) == null) {
            return;
        }
        if (this.fuels.get(event.getFuel().getTypeId()) > 0) {
            short burnTime = this.fuels.get(event.getFuel().getTypeId()).shortValue();
            event.setBurnTime((int)burnTime);
            event.setBurning(true);
        }
    }

    public void addRecipes() {
        try {
            String lastLine;
            File recipeFile = new File(this.plugin.getDataFolder(), "recipes.txt");
            if (!recipeFile.exists()) {
                recipeFile.createNewFile();
            }
            BufferedReader br = new BufferedReader(new FileReader(recipeFile));
            while ((lastLine = br.readLine()) != null) {
                int iidata;
                String idata;
                int iid;
                String[] itemSplit;
                String contents;
                String output;
                lastLine = COMMENT_PATTERN.split(lastLine)[0];
                if ((lastLine = lastLine.trim()).isEmpty()) continue;
                if (lastLine.startsWith("@[")) {
                    String[] items;
                    output = AT_LEFT_BRACKET_PATTERN.split(lastLine)[1].replace("]", "");
                    ShapelessRecipe r = new ShapelessRecipe(this.parseItemStack(output));
                    contents = br.readLine();
                    if (contents == null) continue;
                    contents = COMMENT_PATTERN.split(contents)[0];
                    if ((contents = contents.trim()).isEmpty()) continue;
                    for (String item : items = COMMA_PATTERN.split(contents)) {
                        itemSplit = COLON_PATTERN.split(item);
                        iid = Integer.parseInt(itemSplit[0]);
                        idata = itemSplit[1];
                        iidata = idata.equals("*") ? -1 : Integer.parseInt(idata);
                        r.addIngredient(Material.getMaterial((int)iid), iidata);
                    }
                    if (this.plugin.getServer().addRecipe((Recipe)r)) {
                        this.plugin.getLogger().info("Recipe Added!");
                        continue;
                    }
                    this.plugin.getLogger().warning("Failed to add recipe!");
                    continue;
                }
                if (lastLine.startsWith("$[")) {
                    String[] items;
                    output = DOLLAR_LEFT_BRACKET_PATTERN.split(lastLine)[1].replace("]", "");
                    FurnaceRecipe r = new FurnaceRecipe(this.tryParseItemStack(output), Material.AIR);
                    contents = br.readLine();
                    if (contents == null) continue;
                    contents = COMMENT_PATTERN.split(contents)[0];
                    if ((contents = contents.trim()).isEmpty()) continue;
                    for (String item : items = COMMA_PATTERN.split(contents)) {
                        itemSplit = COLON_PATTERN.split(item);
                        iid = Integer.parseInt(itemSplit[0]);
                        idata = itemSplit[1];
                        iidata = idata.equals("*") ? -1 : Integer.parseInt(idata);
                        r.setInput(Material.getMaterial((int)iid), iidata);
                    }
                    if (this.plugin.getServer().addRecipe((Recipe)r)) {
                        this.plugin.getLogger().info("Recipe Added!");
                        continue;
                    }
                    this.plugin.getLogger().warning("Failed to add recipe!");
                    continue;
                }
                if (lastLine.startsWith("&[")) {
                    output = AMPERSAND_LEFT_BRACKET_PATTERN.split(lastLine)[1].replace("]", "");
                    int id = Integer.parseInt(COLON_PATTERN.split(output)[0]);
                    contents = br.readLine();
                    if (contents == null) continue;
                    contents = COMMENT_PATTERN.split(contents)[0];
                    if ((contents = contents.trim()).isEmpty()) continue;
                    int burnTime = Integer.parseInt(contents);
                    this.fuels.put(id, burnTime);
                    this.plugin.getLogger().info("Furnace Fuel Added!");
                    continue;
                }
                if (lastLine.startsWith("*[")) {
                    output = ASTERISK_LEFT_BRACKET_PATTERN.split(lastLine)[1].replace("]", "");
                    ShapedRecipe r = new ShapedRecipe(this.parseItemStack(output));
                    contents = br.readLine();
                    if (contents == null) continue;
                    contents = COMMENT_PATTERN.split(contents)[0];
                    if ((contents = contents.trim()).isEmpty()) continue;
                    String[] items = COMMA_PATTERN.split(contents);
                    r.shape(new String[]{this.getShapeData(COLON_PATTERN.split(items[0])[0]) + this.getShapeData(COLON_PATTERN.split(items[1])[0]), this.getShapeData(COLON_PATTERN.split(items[2])[0]) + this.getShapeData(COLON_PATTERN.split(items[3])[0])});
                    this.plugin.getLogger().severe(Arrays.toString(r.getShape()));
                    for (String item : items) {
                        itemSplit = COLON_PATTERN.split(item);
                        iid = Integer.parseInt(itemSplit[0]);
                        idata = itemSplit[1];
                        iidata = idata.equals("*") ? -1 : Integer.parseInt(idata);
                        r.setIngredient(String.valueOf(iid).charAt(0), Material.getMaterial((int)iid), iidata);
                    }
                    if (this.plugin.getServer().addRecipe((Recipe)r)) {
                        this.plugin.getLogger().info("Recipe Added!");
                        continue;
                    }
                    this.plugin.getLogger().warning("Failed to add recipe!");
                    continue;
                }
                if (!lastLine.startsWith("[")) continue;
                output = LEFT_BRACKET_PATTERN.split(lastLine)[1].replace("]", "");
                ShapedRecipe r = new ShapedRecipe(this.parseItemStack(output));
                contents = br.readLine();
                if (contents == null) continue;
                contents = COMMENT_PATTERN.split(contents)[0];
                if ((contents = contents.trim()).isEmpty()) continue;
                String[] items = COMMA_PATTERN.split(contents);
                r.shape(new String[]{this.getShapeData(COLON_PATTERN.split(items[0])[0]) + this.getShapeData(COLON_PATTERN.split(items[1])[0]) + this.getShapeData(COLON_PATTERN.split(items[2])[0]), this.getShapeData(COLON_PATTERN.split(items[3])[0]) + this.getShapeData(COLON_PATTERN.split(items[4])[0]) + this.getShapeData(COLON_PATTERN.split(items[5])[0]), this.getShapeData(COLON_PATTERN.split(items[6])[0]) + this.getShapeData(COLON_PATTERN.split(items[7])[0]) + this.getShapeData(COLON_PATTERN.split(items[8])[0])});
                for (String item : items) {
                    itemSplit = COLON_PATTERN.split(item);
                    iid = Integer.parseInt(itemSplit[0]);
                    idata = itemSplit[1];
                    iidata = idata.equals("*") ? -1 : Integer.parseInt(idata);
                    r.setIngredient(String.valueOf(iid).charAt(0), Material.getMaterial((int)iid), iidata);
                }
                if (this.plugin.getServer().addRecipe((Recipe)r)) {
                    this.plugin.getLogger().info("Recipe Added!");
                    continue;
                }
                this.plugin.getLogger().warning("Failed to add recipe!");
            }
            br.close();
        }
        catch (Exception e) {
            try {
                this.plugin.getLogger().severe("Failed to add Custom Recipes!");
                this.plugin.getLogger().severe(GeneralUtil.getStackTrace((Throwable)e));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private ItemStack tryParseItemStack(String output) {
        String[] split = COLON_PATTERN.split(output);
        int id = Integer.parseInt(split[0]);
        String[] split2 = X_PATTERN.split(split[1]);
        short data = Short.parseShort(split2[0]);
        int amount = 1;
        try {
            amount = Integer.parseInt(split2[1]);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return new ItemStack(id, amount, data);
    }

    private ItemStack parseItemStack(String output) {
        String[] split = COLON_PATTERN.split(output);
        int id = Integer.parseInt(split[0]);
        String[] split2 = X_PATTERN.split(split[1]);
        short data = Short.parseShort(split2[0]);
        int amount = Integer.parseInt(split2[1]);
        return new ItemStack(id, amount, data);
    }

    public String getShapeData(String s) {
        s = String.valueOf(s.charAt(0));
        return s;
    }
}

