/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.InsufficientPermissionsException;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.ProcessedMechanismException;
import com.sk89q.craftbook.SourcedBlockRedstoneEvent;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.regions.CuboidRegion;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.GameMode;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gate
extends AbstractMechanic {
    protected final MechanismsPlugin plugin;
    protected final BlockWorldVector pt;
    protected final boolean smallSearchSize;
    protected Sign sign;

    public Gate(BlockWorldVector pt, MechanismsPlugin plugin, boolean smallSearchSize) {
        BlockState state;
        this.pt = pt;
        this.plugin = plugin;
        this.smallSearchSize = smallSearchSize;
        int id = BukkitUtil.toBlock((BlockWorldVector)pt).getTypeId();
        if ((id == 63 || id == 68) && (state = BukkitUtil.toBlock((BlockWorldVector)pt).getState()) instanceof Sign) {
            this.sign = (Sign)state;
        }
    }

    public boolean toggleGates(LocalPlayer player, WorldVector pt, boolean smallSearchSize) {
        LocalWorld world = pt.getWorld();
        int x = pt.getBlockX();
        int y = pt.getBlockY();
        int z = pt.getBlockZ();
        boolean foundGate = false;
        HashSet<BlockVector> visitedColumns = new HashSet<BlockVector>();
        if (smallSearchSize) {
            for (int x1 = x - 1; x1 <= x + 1; ++x1) {
                for (int y1 = y - 2; y1 <= y + 1; ++y1) {
                    for (int z1 = z - 1; z1 <= z + 1; ++z1) {
                        if (!this.recurseColumn(player, new WorldVector(world, x1, y1, z1), visitedColumns, null)) continue;
                        foundGate = true;
                    }
                }
            }
        } else {
            for (int x1 = x - 3; x1 <= x + 3; ++x1) {
                for (int y1 = y - 3; y1 <= y + 6; ++y1) {
                    for (int z1 = z - 3; z1 <= z + 3; ++z1) {
                        if (!this.recurseColumn(player, new WorldVector(world, x1, y1, z1), visitedColumns, null)) continue;
                        foundGate = true;
                    }
                }
            }
        }
        return foundGate;
    }

    public boolean setGateState(LocalPlayer player, WorldVector pt, boolean close, boolean smallSearchSize) {
        LocalWorld world = pt.getWorld();
        int x = pt.getBlockX();
        int y = pt.getBlockY();
        int z = pt.getBlockZ();
        boolean foundGate = false;
        HashSet<BlockVector> visitedColumns = new HashSet<BlockVector>();
        if (smallSearchSize) {
            for (int x1 = x - 1; x1 <= x + 1; ++x1) {
                for (int y1 = y - 2; y1 <= y + 1; ++y1) {
                    for (int z1 = z - 1; z1 <= z + 1; ++z1) {
                        if (!this.recurseColumn(player, new WorldVector(world, x1, y1, z1), visitedColumns, close)) continue;
                        foundGate = true;
                    }
                }
            }
        } else {
            for (int x1 = x - 3; x1 <= x + 3; ++x1) {
                for (int y1 = y - 3; y1 <= y + 6; ++y1) {
                    for (int z1 = z - 3; z1 <= z + 3; ++z1) {
                        if (!this.recurseColumn(player, new WorldVector(world, x1, y1, z1), visitedColumns, close)) continue;
                        foundGate = true;
                    }
                }
            }
        }
        return foundGate;
    }

    private boolean recurseColumn(LocalPlayer player, WorldVector pt, Set<BlockVector> visitedColumns, Boolean close) {
        World world = ((BukkitWorld)pt.getWorld()).getWorld();
        if (this.plugin.getLocalConfiguration().gateSettings.limitColumns && visitedColumns.size() > this.plugin.getLocalConfiguration().gateSettings.maxColumns) {
            return false;
        }
        if (visitedColumns.contains(pt.setY(0).toBlockVector())) {
            return false;
        }
        if (!this.isValidGateBlock(world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ()))) {
            return false;
        }
        int x = pt.getBlockX();
        int y = pt.getBlockY();
        int z = pt.getBlockZ();
        visitedColumns.add(pt.setY(0).toBlockVector());
        int y1 = y + 1;
        while (y1 <= y + 12 && this.isValidGateBlock(world.getBlockAt(x, y1, z))) {
            y = y1++;
        }
        if (world.getBlockTypeIdAt(x, y + 1, z) == 0) {
            return false;
        }
        if (close == null) {
            close = !this.isValidGateBlock(world.getBlockAt(x, y - 1, z));
        }
        return this.toggleColumn(player, (WorldVector)new BlockWorldVector(pt, x, y, z), close, visitedColumns);
    }

    private boolean toggleColumn(LocalPlayer player, WorldVector topPoint, boolean close, Set<BlockVector> visitedColumns) {
        World world = ((BukkitWorld)topPoint.getWorld()).getWorld();
        int x = topPoint.getBlockX();
        int y = topPoint.getBlockY();
        int z = topPoint.getBlockZ();
        int minY = Math.max(0, y - 12);
        int ID = 0;
        if (close) {
            ID = world.getBlockAt(x, y, z).getTypeId();
        }
        for (int y1 = y - 1; y1 >= minY; --y1) {
            BlockState state;
            int cur = world.getBlockTypeIdAt(x, y1, z);
            Block block = BukkitUtil.toWorld((WorldVector)this.pt).getBlockAt(BukkitUtil.toLocation((WorldVector)this.pt));
            Sign sign = null;
            Sign otherSign = null;
            if ((block.getTypeId() == 68 || block.getTypeId() == 63) && (state = block.getState()) instanceof Sign) {
                sign = (Sign)state;
            }
            if (sign != null) {
                otherSign = SignUtil.getNextSign((Sign)sign, (String)sign.getLine(1), (int)4);
            }
            if (sign == null || !sign.getLine(2).equalsIgnoreCase("NoReplace") ? !this.canPassThrough(cur) : cur != 0 && !this.isValidGateBlock(cur)) break;
            if (this.plugin.getLocalConfiguration().mechSettings.stopDestruction) {
                if (ID == 0 || this.hasEnoughBlocks(sign, otherSign)) {
                    if (ID == 0 && this.isValidGateBlock(world.getBlockAt(x, y1, z))) {
                        this.addBlocks(sign, 1);
                    } else if (ID != 0 && this.canPassThrough(world.getBlockAt(x, y1, z).getTypeId()) && this.isValidGateItem(new ItemStack(ID, 1))) {
                        this.removeBlocks(sign, 1);
                    }
                    world.getBlockAt(x, y1, z).setTypeId(ID);
                    this.setBlocks(sign, this.getBlocks(sign, otherSign));
                } else if (!this.hasEnoughBlocks(sign, otherSign) && this.isValidGateItem(new ItemStack(ID, 1)) && player != null) {
                    player.printError("Not enough blocks to trigger mechanic!");
                    return false;
                }
            } else {
                world.getBlockAt(x, y1, z).setTypeId(ID);
            }
            BlockWorldVector pt = new BlockWorldVector(topPoint, x, y1, z);
            this.recurseColumn(player, (WorldVector)new BlockWorldVector(topPoint, pt.add(1, 0, 0)), visitedColumns, close);
            this.recurseColumn(player, (WorldVector)new BlockWorldVector(topPoint, pt.add(-1, 0, 0)), visitedColumns, close);
            this.recurseColumn(player, (WorldVector)new BlockWorldVector(topPoint, pt.add(0, 0, 1)), visitedColumns, close);
            this.recurseColumn(player, (WorldVector)new BlockWorldVector(topPoint, pt.add(0, 0, -1)), visitedColumns, close);
        }
        this.recurseColumn(player, (WorldVector)new BlockWorldVector(topPoint, topPoint.add(1, 0, 0)), visitedColumns, close);
        this.recurseColumn(player, (WorldVector)new BlockWorldVector(topPoint, topPoint.add(-1, 0, 0)), visitedColumns, close);
        this.recurseColumn(player, (WorldVector)new BlockWorldVector(topPoint, topPoint.add(0, 0, 1)), visitedColumns, close);
        this.recurseColumn(player, (WorldVector)new BlockWorldVector(topPoint, topPoint.add(0, 0, -1)), visitedColumns, close);
        this.recurseColumn(player, (WorldVector)new BlockWorldVector(topPoint, topPoint.add(1, 1, 0)), visitedColumns, close);
        this.recurseColumn(player, (WorldVector)new BlockWorldVector(topPoint, topPoint.add(-1, 1, 0)), visitedColumns, close);
        this.recurseColumn(player, (WorldVector)new BlockWorldVector(topPoint, topPoint.add(0, 1, 1)), visitedColumns, close);
        this.recurseColumn(player, (WorldVector)new BlockWorldVector(topPoint, topPoint.add(0, 1, -1)), visitedColumns, close);
        return true;
    }

    public void onRightClick(PlayerInteractEvent event) {
        BlockState state;
        if (!this.plugin.getLocalConfiguration().gateSettings.enable) {
            return;
        }
        LocalPlayer player = this.plugin.wrap(event.getPlayer());
        Sign sign = null;
        if ((event.getClickedBlock().getTypeId() == 63 || event.getClickedBlock().getTypeId() == 68) && (state = event.getClickedBlock().getState()) instanceof Sign) {
            sign = (Sign)state;
        }
        if (sign == null) {
            return;
        }
        if (this.getGateBlock() == player.getTypeInHand()) {
            int amount = 1;
            if (event.getPlayer().isSneaking() && event.getPlayer().getItemInHand().getAmount() >= 5) {
                amount = 5;
            }
            this.addBlocks(sign, amount);
            if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                if (event.getPlayer().getItemInHand().getAmount() <= amount) {
                    event.getPlayer().setItemInHand(new ItemStack(0, 0));
                } else {
                    event.getPlayer().getItemInHand().setAmount(event.getPlayer().getItemInHand().getAmount() - amount);
                }
            }
            player.print("mech.restock");
            event.setCancelled(true);
            return;
        }
        if (!player.hasPermission("craftbook.mech.gate.use")) {
            player.printError("mech.use-permission");
            return;
        }
        if (this.toggleGates(player, (WorldVector)this.pt, this.smallSearchSize)) {
            player.print("mech.gate.toggle");
        } else {
            player.printError("mech.gate.not-found");
        }
        event.setCancelled(true);
    }

    public void onBlockRedstoneChange(final SourcedBlockRedstoneEvent event) {
        if (!this.plugin.getLocalConfiguration().gateSettings.enableRedstone) {
            return;
        }
        if (event.getNewCurrent() == event.getOldCurrent()) {
            return;
        }
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            public void run() {
                Gate.this.setGateState(null, (WorldVector)Gate.this.pt, event.getNewCurrent() > 0, Gate.this.smallSearchSize);
            }
        }, 2L);
    }

    public boolean isValidGateBlock(Block block) {
        return this.isValidGateBlock(block.getTypeId());
    }

    public boolean isValidGateBlock(int block) {
        BlockState state;
        Block b = BukkitUtil.toWorld((WorldVector)this.pt).getBlockAt(BukkitUtil.toLocation((WorldVector)this.pt));
        Sign sign = null;
        if ((b.getTypeId() == 68 || b.getTypeId() == 63) && (state = b.getState()) instanceof Sign) {
            sign = (Sign)state;
        }
        if (sign != null && !sign.getLine(0).isEmpty()) {
            try {
                int id = Integer.parseInt(sign.getLine(0));
                return block == id;
            }
            catch (Exception e) {
                return this.plugin.getLocalConfiguration().gateSettings.canUseBlock(block);
            }
        }
        return this.plugin.getLocalConfiguration().gateSettings.canUseBlock(block);
    }

    public boolean isValidGateItem(ItemStack block) {
        return this.isValidGateItem(block.getTypeId());
    }

    public boolean isValidGateItem(int block) {
        BlockState state;
        Block b = BukkitUtil.toWorld((WorldVector)this.pt).getBlockAt(BukkitUtil.toLocation((WorldVector)this.pt));
        Sign sign = null;
        if ((b.getTypeId() == 68 || b.getTypeId() == 63) && (state = b.getState()) instanceof Sign) {
            sign = (Sign)state;
        }
        if (sign != null && !sign.getLine(0).isEmpty()) {
            try {
                int id = Integer.parseInt(sign.getLine(0));
                return block == id;
            }
            catch (Exception e) {
                return this.plugin.getLocalConfiguration().gateSettings.canUseBlock(block);
            }
        }
        return this.plugin.getLocalConfiguration().gateSettings.canUseBlock(block);
    }

    public void onBlockBreak(BlockBreakEvent event) {
        BlockState state;
        Sign sign = null;
        if ((event.getBlock().getTypeId() == 68 || event.getBlock().getTypeId() == 63) && (state = event.getBlock().getState()) instanceof Sign) {
            sign = (Sign)state;
        }
        if (sign == null) {
            return;
        }
        if (this.hasEnoughBlocks(sign)) {
            ItemStack toDrop = new ItemStack(this.getGateBlock(), this.getBlocks(sign));
            sign.getWorld().dropItemNaturally(sign.getLocation(), toDrop);
        }
    }

    private boolean canPassThrough(int t) {
        int[] passableBlocks = new int[]{8, 9, 10, 11, 78, 31, 106, 32, 0};
        for (int aPassableBlock : passableBlocks) {
            if (aPassableBlock != t) continue;
            return true;
        }
        return this.isValidGateBlock(t);
    }

    public int getGateBlock() {
        if (!this.sign.getLine(0).isEmpty()) {
            try {
                return Integer.parseInt(this.sign.getLine(0));
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        LocalWorld world = this.pt.getWorld();
        int x = this.pt.getBlockX();
        int y = this.pt.getBlockY();
        int z = this.pt.getBlockZ();
        if (this.smallSearchSize) {
            for (int x1 = x - 1; x1 <= x + 1; ++x1) {
                for (int y1 = y - 2; y1 <= y + 1; ++y1) {
                    for (int z1 = z - 1; z1 <= z + 1; ++z1) {
                        if (this.getFirstBlock(new WorldVector(world, x1, y1, z1)) == 0) continue;
                        return this.getFirstBlock(new WorldVector(world, x1, y1, z1));
                    }
                }
            }
        } else {
            for (int x1 = x - 3; x1 <= x + 3; ++x1) {
                for (int y1 = y - 3; y1 <= y + 6; ++y1) {
                    for (int z1 = z - 3; z1 <= z + 3; ++z1) {
                        if (this.getFirstBlock(new WorldVector(world, x1, y1, z1)) == 0) continue;
                        return this.getFirstBlock(new WorldVector(world, x1, y1, z1));
                    }
                }
            }
        }
        return 85;
    }

    public int getFirstBlock(WorldVector pt) {
        World world = ((BukkitWorld)pt.getWorld()).getWorld();
        if (!this.isValidGateBlock(world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ()))) {
            return 0;
        }
        return world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ()).getTypeId();
    }

    public boolean removeBlocks(Sign s, int amount) {
        if (s.getLine(3).equalsIgnoreCase("infinite")) {
            return true;
        }
        int curBlocks = this.getBlocks(s) - amount;
        s.setLine(3, String.valueOf(curBlocks));
        s.update();
        return curBlocks >= 3;
    }

    public boolean addBlocks(Sign s, int amount) {
        if (s.getLine(3).equalsIgnoreCase("infinite")) {
            return true;
        }
        int curBlocks = this.getBlocks(s) + amount;
        s.setLine(3, String.valueOf(curBlocks));
        s.update();
        return curBlocks >= 0;
    }

    public void setBlocks(Sign s, int amount) {
        if (s.getLine(3).equalsIgnoreCase("infinite")) {
            return;
        }
        s.setLine(3, String.valueOf(amount));
        s.update();
    }

    public int getBlocks(Sign s) {
        if (s.getLine(3).equalsIgnoreCase("infinite")) {
            return 0;
        }
        return this.getBlocks(s, null);
    }

    public int getBlocks(Sign s, Sign other) {
        if (s.getLine(3).equalsIgnoreCase("infinite") || other != null && other.getLine(3).equalsIgnoreCase("infinite")) {
            return 0;
        }
        int curBlocks = 0;
        try {
            curBlocks = Integer.parseInt(s.getLine(3));
            try {
                this.setBlocks(s, curBlocks += Integer.parseInt(other.getLine(3)));
                this.setBlocks(other, 0);
            }
            catch (Exception ignored) {}
        }
        catch (Exception e) {
            curBlocks = 0;
        }
        return curBlocks;
    }

    public boolean hasEnoughBlocks(Sign s) {
        return s.getLine(3).equalsIgnoreCase("infinite") || this.getBlocks(s) > 0;
    }

    public boolean hasEnoughBlocks(Sign s, Sign other) {
        return s != null && s.getLine(3).equalsIgnoreCase("infinite") || other != null && other.getLine(3).equalsIgnoreCase("infinite") || this.getBlocks(s, other) > 0;
    }

    protected class GateColumn {
        private final BlockWorldVector bwv;

        public GateColumn(LocalWorld world, int x, int y, int z) {
            this.bwv = new BlockWorldVector(world, x, y, z);
        }

        public BlockVector getStartingPoint() {
            return this.bwv.toBlockVector();
        }

        public BlockVector getEndingPoint() {
            return new BlockVector(this.bwv.getBlockX(), this.getEndingY(), this.bwv.getBlockZ());
        }

        public int getStartingY() {
            return this.bwv.getBlockY();
        }

        public int getEndingY() {
            for (int y = this.bwv.getBlockY(); y > 0; --y) {
                if (Gate.this.canPassThrough(this.bwv.getWorld().getBlockType((Vector)this.bwv.toBlockVector()))) continue;
                return y + 1;
            }
            return 0;
        }

        public int getX() {
            return this.bwv.getBlockX();
        }

        public int getZ() {
            return this.bwv.getBlockZ();
        }

        public CuboidRegion getRegion() {
            return new CuboidRegion((Vector)this.getStartingPoint(), (Vector)this.getEndingPoint());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<Gate> {
        protected final MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        public Gate detect(BlockWorldVector pt) {
            Sign sign;
            BlockState state;
            Block block = BukkitUtil.toWorld((WorldVector)pt).getBlockAt(BukkitUtil.toLocation((WorldVector)pt));
            if ((block.getTypeId() == 68 || block.getTypeId() == 63) && (state = block.getState()) instanceof Sign && ((sign = (Sign)state).getLine(1).equalsIgnoreCase("[Gate]") || sign.getLine(1).equalsIgnoreCase("[DGate]"))) {
                return new Gate(pt, this.plugin, sign.getLine(1).equalsIgnoreCase("[DGate]"));
            }
            return null;
        }

        public Gate detect(BlockWorldVector pt, LocalPlayer player, ChangedSign sign) throws InvalidMechanismException, ProcessedMechanismException {
            if (sign.getLine(1).equalsIgnoreCase("[Gate]")) {
                player.checkPermission("craftbook.mech.gate");
                String line0 = sign.getLine(0).trim();
                if (line0 != null && !line0.isEmpty()) {
                    try {
                        int iLine0 = Integer.parseInt(line0);
                        if (iLine0 != 0 && !this.isValidGateBlock(iLine0)) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new InvalidMechanismException("Line 1 needs to be a valid block id.");
                    }
                }
                sign.setLine(1, "[Gate]");
                if (sign.getLine(3).equalsIgnoreCase("infinite") && !player.hasPermission("craftbook.mech.gate.infinite")) {
                    sign.setLine(3, "0");
                } else if (!sign.getLine(3).equalsIgnoreCase("infinite")) {
                    sign.setLine(3, "0");
                }
                sign.update(false);
                player.print("mech.gate.create");
            } else if (sign.getLine(1).equalsIgnoreCase("[DGate]")) {
                if (!player.hasPermission("craftbook.mech.gate") && !player.hasPermission("craftbook.mech.dgate")) {
                    throw new InsufficientPermissionsException();
                }
                String line0 = sign.getLine(0).trim();
                if (line0 != null && !line0.isEmpty()) {
                    try {
                        if (!this.isValidGateBlock(Integer.parseInt(line0))) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new InvalidMechanismException("Line 1 needs to be a valid block id.");
                    }
                }
                sign.setLine(1, "[DGate]");
                if (sign.getLine(3).equalsIgnoreCase("infinite") && !player.hasPermission("craftbook.mech.gate.infinite")) {
                    sign.setLine(3, "0");
                } else if (!sign.getLine(3).equalsIgnoreCase("infinite")) {
                    sign.setLine(3, "0");
                }
                sign.update(false);
                player.print("mech.dgate.create");
            } else {
                return null;
            }
            throw new ProcessedMechanismException();
        }

        public boolean isValidGateBlock(int block) {
            return this.plugin.getLocalConfiguration().gateSettings.canUseBlock(block);
        }
    }
}

