/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.InsufficientPermissionsException;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.ProcessedMechanismException;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.event.player.PlayerInteractEvent;

public class MapChanger
extends AbstractMechanic {
    private MapChanger(Block trigger, MechanismsPlugin plugin) throws InvalidMechanismException {
    }

    public void onRightClick(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        if (event.getPlayer().getItemInHand() != null && event.getPlayer().getItemInHand().getTypeId() == 358 && block.getState() instanceof Sign) {
            int id;
            Sign sign = (Sign)block.getState();
            try {
                id = Byte.parseByte(sign.getLine(2));
            }
            catch (Exception e) {
                id = -1;
            }
            if (id == -1) {
                event.getPlayer().sendMessage("Invalid Map!");
            }
            event.getPlayer().getItemInHand().setDurability((short)id);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<MapChanger> {
        private final MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        public MapChanger detect(BlockWorldVector pt) throws InvalidMechanismException {
            Sign s;
            Block block = BukkitUtil.toBlock((BlockWorldVector)pt);
            if (block.getState() instanceof Sign && (s = (Sign)block.getState()).getLine(1).equalsIgnoreCase("[Map]")) {
                return new MapChanger(block, this.plugin);
            }
            return null;
        }

        public MapChanger detect(BlockWorldVector pt, LocalPlayer player, ChangedSign sign) throws InvalidMechanismException, ProcessedMechanismException {
            if (!sign.getLine(1).equalsIgnoreCase("[Map]")) {
                return null;
            }
            if (!player.hasPermission("craftbook.mech.map")) {
                throw new InsufficientPermissionsException();
            }
            player.print("mech.map.create");
            sign.setLine(1, "[Map]");
            throw new ProcessedMechanismException();
        }
    }
}

