/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.InsufficientPermissionsException;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.ProcessedMechanismException;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.Location;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BlockType;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import java.util.regex.Pattern;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.material.Button;

public class Teleporter
extends AbstractMechanic {
    private static final Pattern COLON_PATTERN = Pattern.compile(":", 16);
    private final MechanismsPlugin plugin;
    private final Block trigger;

    private Teleporter(Block trigger, MechanismsPlugin plugin) throws InvalidMechanismException {
        this.trigger = trigger;
        this.plugin = plugin;
    }

    public void onRightClick(PlayerInteractEvent event) {
        if (!this.plugin.getLocalConfiguration().teleporterSettings.enable) {
            return;
        }
        if (!BukkitUtil.toWorldVector((Block)event.getClickedBlock()).equals((Object)BukkitUtil.toWorldVector((Block)this.trigger))) {
            return;
        }
        LocalPlayer localPlayer = this.plugin.wrap(event.getPlayer());
        if (!localPlayer.hasPermission("craftbook.mech.teleporter.use")) {
            localPlayer.printError("mech.use-permission");
            return;
        }
        this.makeItSo(this.plugin.wrap(event.getPlayer()));
        event.setCancelled(true);
    }

    private void makeItSo(LocalPlayer player) {
        Block floor;
        Block location;
        double toX = 0.0;
        double toY = 0.0;
        double toZ = 0.0;
        if (this.trigger.getState() instanceof Sign) {
            Sign s = (Sign)this.trigger.getState();
            String[] pos = COLON_PATTERN.split(s.getLine(2));
            if (pos.length > 2) {
                try {
                    toX = Double.parseDouble(pos[0]);
                    toY = Double.parseDouble(pos[1]);
                    toZ = Double.parseDouble(pos[2]);
                }
                catch (Exception e) {
                    return;
                }
            } else {
                return;
            }
        }
        if (this.plugin.getLocalConfiguration().teleporterSettings.requiresign && (location = this.trigger.getWorld().getBlockAt((int)toX, (int)toY, (int)toZ)).getTypeId() != 68 && location.getTypeId() != 63) {
            if (location.getTypeId() == 77 || location.getTypeId() == 143) {
                Sign s;
                Button b = (Button)location.getState().getData();
                Block sign = location.getRelative(b.getAttachedFace()).getRelative(b.getAttachedFace());
                if (sign.getState() instanceof Sign && !(s = (Sign)sign.getState()).getLine(1).equalsIgnoreCase("[Teleporter]")) {
                    player.printError("mech.teleport.sign");
                    return;
                }
            } else {
                player.printError("mech.teleport.sign");
                return;
            }
        }
        if (!Teleporter.occupiable(floor = this.trigger.getWorld().getBlockAt((int)Math.floor(toX), (int)(Math.floor(toY) + 1.0), (int)Math.floor(toZ)))) {
            floor = floor.getRelative(BlockFace.DOWN);
        }
        int foundFree = 0;
        for (int i = 0; i < 5 && Teleporter.occupiable(floor); ++i) {
            ++foundFree;
            if (floor.getY() == 0) break;
            floor = floor.getRelative(BlockFace.DOWN);
        }
        if (foundFree < 2) {
            player.printError("mech.lift.obstruct");
            return;
        }
        Location subspaceRift = player.getPosition();
        subspaceRift = subspaceRift.setPosition(new Vector((double)floor.getX() + 0.5, (double)(floor.getY() + 1), (double)floor.getZ() + 0.5));
        if (player.isInsideVehicle()) {
            subspaceRift = player.getVehicle().getLocation();
            subspaceRift = subspaceRift.setPosition(new Vector((double)floor.getX() + 0.5, (double)(floor.getY() + 2), (double)floor.getZ() + 0.5));
            player.getVehicle().teleport(subspaceRift);
        }
        if (this.plugin.getLocalConfiguration().teleporterSettings.maxrange > 0 && subspaceRift.getPosition().distanceSq(player.getPosition().getPosition()) > (double)(this.plugin.getLocalConfiguration().teleporterSettings.maxrange * this.plugin.getLocalConfiguration().teleporterSettings.maxrange)) {
            player.print("mech.teleport.range");
            return;
        }
        player.teleport(subspaceRift);
        player.print("mech.teleport.alert");
    }

    private static boolean occupiable(Block block) {
        return BlockType.canPassThrough((int)block.getTypeId());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<Teleporter> {
        private final MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        public Teleporter detect(BlockWorldVector pt) throws InvalidMechanismException {
            Button b;
            Block sign;
            Block block = BukkitUtil.toBlock((BlockWorldVector)pt);
            if (block.getState() instanceof Sign) {
                Sign s = (Sign)block.getState();
                if (!s.getLine(1).equalsIgnoreCase("[Teleporter]")) {
                    return null;
                }
                String[] pos = COLON_PATTERN.split(s.getLine(2));
                if (pos.length > 2) {
                    return new Teleporter(block, this.plugin);
                }
            } else if ((block.getTypeId() == 77 || block.getTypeId() == 143) && (sign = block.getRelative((b = (Button)block.getState().getData()).getAttachedFace()).getRelative(b.getAttachedFace())).getState() instanceof Sign) {
                Sign s = (Sign)sign.getState();
                if (!s.getLine(1).equalsIgnoreCase("[Teleporter]")) {
                    return null;
                }
                String[] pos = COLON_PATTERN.split(s.getLine(2));
                if (pos.length > 2) {
                    return new Teleporter(block, this.plugin);
                }
            }
            return null;
        }

        public Teleporter detect(BlockWorldVector pt, LocalPlayer player, ChangedSign sign) throws InvalidMechanismException, ProcessedMechanismException {
            if (!sign.getLine(1).equalsIgnoreCase("[Teleporter]")) {
                return null;
            }
            if (!player.hasPermission("craftbook.mech.teleporter")) {
                throw new InsufficientPermissionsException();
            }
            player.print("mech.teleport.create");
            sign.setLine(1, "[Teleporter]");
            String[] pos = COLON_PATTERN.split(sign.getLine(2));
            if (pos.length <= 2) {
                return null;
            }
            throw new ProcessedMechanismException();
        }
    }
}

