/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech.area;

import com.sk89q.craftbook.mech.area.CuboidCopyException;
import com.sk89q.craftbook.mech.area.FlatCuboidCopy;
import com.sk89q.craftbook.mech.area.MCEditCuboidCopy;
import com.sk89q.craftbook.util.GeneralUtil;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BlockType;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import com.sk89q.worldedit.data.DataException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.inventory.InventoryHolder;

public abstract class CuboidCopy {
    protected World world;
    protected Vector origin;
    protected Vector size;
    protected int width;
    protected int height;
    protected int length;

    public CuboidCopy(Vector origin, Vector size, World world) {
        this.origin = origin;
        this.size = size;
        this.world = world;
        this.width = size.getBlockX();
        this.height = size.getBlockY();
        this.length = size.getBlockZ();
    }

    protected CuboidCopy() {
    }

    public static CuboidCopy load(File file, World world) throws CuboidCopyException {
        int index = file.getName().lastIndexOf(46);
        String extension = file.getName().substring(index);
        CuboidCopy copy = null;
        if (extension.equalsIgnoreCase(".cbcopy")) {
            copy = new FlatCuboidCopy();
        } else if (extension.equalsIgnoreCase(".schematic")) {
            copy = new MCEditCuboidCopy(world);
        }
        if (copy == null) {
            throw new CuboidCopyException("The file " + file.getAbsolutePath() + " does not exist.");
        }
        try {
            ((CuboidCopy)copy).loadFromFile(file);
        }
        catch (IOException e) {
            Bukkit.getLogger().severe(GeneralUtil.getStackTrace((Throwable)e));
            throw new CuboidCopyException(e.getMessage());
        }
        catch (DataException e) {
            Bukkit.getLogger().severe(GeneralUtil.getStackTrace((Throwable)e));
            throw new CuboidCopyException(e.getMessage());
        }
        return copy;
    }

    public void clear() {
        if (this.world == null || this.origin == null) {
            return;
        }
        ArrayList<Vector> queued = new ArrayList<Vector>();
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.length; ++z) {
                    Vector pt = this.origin.add(x, y, z);
                    if (pt == null) continue;
                    if (BlockType.shouldPlaceLast((int)this.world.getBlockTypeIdAt(BukkitUtil.toLocation((World)this.world, (Vector)pt)))) {
                        Block block = this.world.getBlockAt(BukkitUtil.toLocation((World)this.world, (Vector)pt));
                        if (block instanceof InventoryHolder) {
                            InventoryHolder holder = (InventoryHolder)block;
                            holder.getInventory().clear();
                        }
                        block.setTypeId(0);
                        continue;
                    }
                    queued.add(pt);
                }
            }
        }
        for (Vector pt : queued) {
            Block block = this.world.getBlockAt(BukkitUtil.toLocation((World)this.world, (Vector)pt));
            if (block instanceof InventoryHolder) {
                InventoryHolder holder = (InventoryHolder)block;
                holder.getInventory().clear();
            }
            block.setTypeId(0);
        }
    }

    public double distance(Vector pos) {
        Vector max = this.origin.add(new Vector(this.width, this.height, this.length));
        int closestX = Math.max(this.origin.getBlockX(), Math.min(max.getBlockX(), pos.getBlockX()));
        int closestY = Math.max(this.origin.getBlockY(), Math.min(max.getBlockY(), pos.getBlockY()));
        int closestZ = Math.max(this.origin.getBlockZ(), Math.min(max.getBlockZ(), pos.getBlockZ()));
        return pos.distance(new Vector(closestX, closestY, closestZ));
    }

    protected abstract void save(File var1) throws IOException, DataException;

    protected abstract void loadFromFile(File var1) throws IOException, CuboidCopyException, DataException;

    public abstract void paste();

    public abstract void copy();
}

