/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech.area;

import com.sk89q.craftbook.mech.area.CuboidCopy;
import com.sk89q.craftbook.mech.area.CuboidCopyException;
import com.sk89q.craftbook.util.Tuple2;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BlockType;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.bukkit.World;

public class FlatCuboidCopy
extends CuboidCopy {
    private byte[] blocks;
    private byte[] data;

    public FlatCuboidCopy(Vector origin, Vector size, World world) {
        super(origin, size, world);
        this.blocks = new byte[this.width * this.height * this.length];
        this.data = new byte[this.width * this.height * this.length];
    }

    protected FlatCuboidCopy() {
    }

    public void save(File dest) throws IOException {
        FileOutputStream out = new FileOutputStream(dest);
        DataOutputStream writer = new DataOutputStream(out);
        writer.writeByte(1);
        writer.writeInt(this.origin.getBlockX());
        writer.writeInt(this.origin.getBlockY());
        writer.writeInt(this.origin.getBlockZ());
        writer.writeInt(this.width);
        writer.writeInt(this.height);
        writer.writeInt(this.length);
        writer.write(this.blocks, 0, this.blocks.length);
        writer.write(this.data, 0, this.data.length);
        writer.close();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromFile(File file) throws IOException, CuboidCopyException {
        byte[] data;
        byte[] blocks;
        int length;
        int height;
        int width;
        int z;
        int y;
        int x;
        FileInputStream in = new FileInputStream(file);
        DataInputStream reader = new DataInputStream(in);
        try {
            byte version = reader.readByte();
            x = reader.readInt();
            y = reader.readInt();
            z = reader.readInt();
            width = reader.readInt();
            height = reader.readInt();
            length = reader.readInt();
            int size = width * height * length;
            blocks = new byte[size];
            if (reader.read(blocks, 0, size) != size) {
                throw new CuboidCopyException("File error: Bad size");
            }
            data = new byte[size];
            if (reader.read(data, 0, size) != size) {
                throw new CuboidCopyException("File error: Bad size");
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ignored) {}
        }
        this.origin = new Vector(x, y, z);
        this.width = width;
        this.height = height;
        this.length = length;
        this.blocks = blocks;
        this.data = data;
    }

    public void copy() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.length; ++z) {
                    int index = y * this.width * this.length + z * this.width + x;
                    this.blocks[index] = (byte)this.world.getBlockTypeIdAt(BukkitUtil.toLocation((World)this.world, (Vector)this.origin.add(x, y, z)));
                    this.data[index] = this.world.getBlockAt(BukkitUtil.toLocation((World)this.world, (Vector)this.origin.add(x, y, z))).getData();
                }
            }
        }
    }

    public void paste() {
        ArrayList<Tuple2> queueAfter = new ArrayList<Tuple2>();
        ArrayList<Tuple2> queueLast = new ArrayList<Tuple2>();
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.length; ++z) {
                    int index = y * this.width * this.length + z * this.width + x;
                    Vector pt = this.origin.add(x, y, z);
                    if (BlockType.shouldPlaceLast((int)this.world.getBlockTypeIdAt(BukkitUtil.toLocation((World)this.world, (Vector)pt)))) {
                        this.world.getBlockAt(BukkitUtil.toLocation((World)this.world, (Vector)pt)).setTypeId(0);
                    }
                    if (BlockType.shouldPlaceLast((int)this.blocks[index])) {
                        queueLast.add(new Tuple2((Object)pt, (Object)new byte[]{this.blocks[index], this.data[index]}));
                        continue;
                    }
                    queueAfter.add(new Tuple2((Object)pt, (Object)new byte[]{this.blocks[index], this.data[index]}));
                }
            }
        }
        for (Tuple2 entry : queueAfter) {
            byte[] v = (byte[])entry.b;
            this.world.getBlockAt(BukkitUtil.toLocation((World)this.world, (Vector)((Vector)entry.a))).setTypeId((int)v[0]);
            if (!BlockType.usesData((int)v[0])) continue;
            this.world.getBlockAt(BukkitUtil.toLocation((World)this.world, (Vector)((Vector)entry.a))).setData(v[1]);
        }
        for (Tuple2 entry : queueLast) {
            byte[] v = (byte[])entry.b;
            this.world.getBlockAt(BukkitUtil.toLocation((World)this.world, (Vector)((Vector)entry.a))).setTypeId((int)v[0]);
            if (!BlockType.usesData((int)v[0])) continue;
            this.world.getBlockAt(BukkitUtil.toLocation((World)this.world, (Vector)((Vector)entry.a))).setData(v[1]);
        }
    }
}

