/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech.arrows;

import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.craftbook.mech.arrows.ElementalArrow;
import com.sk89q.craftbook.mech.arrows.FireArrow;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Arrow;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;

public class ElementalArrowsMechanic
implements Listener {
    MechanismsPlugin plugin;
    List<ElementalArrow> arrows = new ArrayList<ElementalArrow>();

    public ElementalArrowsMechanic(MechanismsPlugin plugin) {
        this.plugin = plugin;
        this.registerArrow(new FireArrow(plugin));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onArrowHit(ProjectileHitEvent event) {
        if (event.getEntity() instanceof Arrow) {
            for (ElementalArrow e : this.arrows) {
                if (!e.onHit(event)) continue;
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onArrowShot(ProjectileLaunchEvent event) {
        if (event.getEntity() instanceof Arrow) {
            for (ElementalArrow e : this.arrows) {
                if (!e.onShoot(event)) continue;
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onItemCraft(PrepareItemCraftEvent event) {
        for (ElementalArrow e : this.arrows) {
            if (!e.onCraft(event)) continue;
            return;
        }
    }

    public void registerArrow(ElementalArrow arrow) {
        arrow.addRecipe();
        this.arrows.add(arrow);
    }
}

