/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech.cauldron;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CauldronItemStack
implements Comparable<CauldronItemStack> {
    private static final Pattern COLON_PATTERN = Pattern.compile(":", 16);
    private Material material;
    private short data;
    private int amount;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.amount;
        result = 31 * result + this.data;
        result = 31 * result + (this.material == null ? 0 : this.material.hashCode());
        return result;
    }

    public static Collection<CauldronItemStack> convert(Collection<Item> stacks) {
        HashMap<String, Integer> items = new HashMap<String, Integer>();
        for (Item item : stacks) {
            ItemStack itemStack = item.getItemStack();
            String name = itemStack.getType() + ":" + itemStack.getDurability();
            if (items.containsKey(name)) {
                items.put(name, (Integer)items.get(name) + itemStack.getAmount());
                continue;
            }
            items.put(name, itemStack.getAmount());
        }
        LinkedHashSet<CauldronItemStack> stackSet = new LinkedHashSet<CauldronItemStack>();
        for (Map.Entry entry : items.entrySet()) {
            String[] split = COLON_PATTERN.split((CharSequence)entry.getKey());
            stackSet.add(new CauldronItemStack(Material.getMaterial((String)split[0]), Short.parseShort(split[1]), (Integer)entry.getValue()));
        }
        return stackSet;
    }

    public CauldronItemStack(Material material, short data, int amount) {
        this.material = material;
        this.data = data;
        this.amount = amount;
    }

    public CauldronItemStack(Material material, int amount) {
        this.material = material;
        this.amount = amount;
    }

    public CauldronItemStack(Material material, short data) {
        this(material, data, 0);
    }

    public CauldronItemStack(Material material) {
        this(material, 0);
    }

    public Material getMaterial() {
        return this.material;
    }

    public short getData() {
        return this.data;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public void setData(short data) {
        this.data = data;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public ItemStack getItemStack() {
        return new ItemStack(this.material, this.amount, this.data);
    }

    public CauldronItemStack add(CauldronItemStack stack) {
        if (stack.equals(this)) {
            this.amount += stack.getAmount();
        }
        return this;
    }

    public boolean isSameType(CauldronItemStack stack) {
        if (this.data < 0 || stack.getData() < 0) {
            return stack.getMaterial() == this.getMaterial();
        }
        return stack.getMaterial() == this.getMaterial() && stack.getData() == this.getData();
    }

    @Override
    public int compareTo(CauldronItemStack stack) {
        if (this.getAmount() > stack.getAmount()) {
            return 1;
        }
        if (this.getAmount() == stack.getAmount()) {
            return 0;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CauldronItemStack) {
            CauldronItemStack stack = (CauldronItemStack)obj;
            return this.isSameType(stack) && stack.getAmount() == this.getAmount();
        }
        return false;
    }
}

