/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech.crafting;

import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.craftbook.mech.crafting.CraftingItemStack;
import com.sk89q.craftbook.mech.crafting.RecipeManager;
import com.sk89q.craftbook.util.GeneralUtil;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class CustomCrafting {
    protected final RecipeManager recipes;
    protected final MechanismsPlugin plugin;

    public CustomCrafting(MechanismsPlugin plugin) {
        this.plugin = plugin;
        this.recipes = new RecipeManager((FileConfiguration)YamlConfiguration.loadConfiguration((File)new File(plugin.getDataFolder(), "crafting-recipes.yml")), plugin.getDataFolder());
        Collection<RecipeManager.Recipe> recipeCollection = this.recipes.getRecipes();
        for (RecipeManager.Recipe r : recipeCollection) {
            try {
                ShapelessRecipe sh;
                if (r.getType() == RecipeManager.Recipe.RecipeType.SHAPELESS) {
                    sh = new ShapelessRecipe(r.getResult().getItemStack());
                    for (CraftingItemStack craftingItemStack : r.getIngredients()) {
                        sh.addIngredient(craftingItemStack.getAmount(), craftingItemStack.getMaterial(), (int)craftingItemStack.getData());
                    }
                    plugin.getServer().addRecipe((Recipe)sh);
                    continue;
                }
                if (r.getType() == RecipeManager.Recipe.RecipeType.SHAPED2X2) {
                    sh = new ShapedRecipe(r.getResult().getItemStack());
                    sh.shape(r.getShape());
                    for (Map.Entry entry : r.getShapedIngredients().entrySet()) {
                        sh.setIngredient(((Character)entry.getValue()).charValue(), ((CraftingItemStack)entry.getKey()).getMaterial(), (int)((CraftingItemStack)entry.getKey()).getData());
                    }
                    plugin.getServer().addRecipe((Recipe)sh);
                    continue;
                }
                if (r.getType() == RecipeManager.Recipe.RecipeType.SHAPED3X3) {
                    sh = new ShapedRecipe(r.getResult().getItemStack());
                    sh.shape(r.getShape());
                    for (Map.Entry entry : r.getShapedIngredients().entrySet()) {
                        sh.setIngredient(((Character)entry.getValue()).charValue(), ((CraftingItemStack)entry.getKey()).getMaterial(), (int)((CraftingItemStack)entry.getKey()).getData());
                    }
                    plugin.getServer().addRecipe((Recipe)sh);
                    continue;
                }
                if (r.getType() != RecipeManager.Recipe.RecipeType.FURNACE) continue;
                sh = new FurnaceRecipe(r.getResult().getItemStack(), r.getResult().getMaterial());
                for (CraftingItemStack craftingItemStack : r.getIngredients()) {
                    sh.setInput(craftingItemStack.getMaterial(), (int)craftingItemStack.getData());
                }
                plugin.getServer().addRecipe((Recipe)sh);
            }
            catch (IllegalArgumentException e) {
                plugin.getLogger().severe("Corrupt or invalid recipe!");
                plugin.getLogger().severe("Please either delete custom-crafting.yml, or fix the issues with your recipes file!");
            }
            catch (Exception e) {
                plugin.getLogger().severe("Failed to load recipe!");
                plugin.getLogger().severe(GeneralUtil.getStackTrace((Throwable)e));
            }
        }
    }
}

