/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.bukkit;

import com.sk89q.craftbook.InsufficientPermissionsException;
import com.sk89q.craftbook.LanguageManager;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.RailUtil;
import com.sk89q.craftbook.SourcedBlockRedstoneEvent;
import com.sk89q.craftbook.VehiclesConfiguration;
import com.sk89q.craftbook.bukkit.BaseBukkitPlugin;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.bukkit.Metrics;
import com.sk89q.craftbook.bukkit.commands.VehicleCommands;
import com.sk89q.craftbook.cart.CartMechanism;
import com.sk89q.craftbook.cart.MinecartManager;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class VehiclesPlugin
extends BaseBukkitPlugin {
    private static VehiclesPlugin instance;
    private VehiclesConfiguration config;
    private MinecartManager cartman;
    private Map<String, String> stationSelection;

    public void onEnable() {
        instance = this;
        this.stationSelection = new HashMap<String, String>();
        super.onEnable();
        this.createDefaultConfiguration("config.yml", false);
        this.config = new VehiclesConfiguration(this.getConfig(), this.getDataFolder());
        this.saveConfig();
        this.cartman = new MinecartManager(this);
        this.registerEvents();
        this.languageManager = new LanguageManager((BaseBukkitPlugin)this);
        this.registerCommand(VehicleCommands.class);
        try {
            Metrics metrics = new Metrics((Plugin)this);
            Metrics.Graph graph = metrics.createGraph("Language");
            for (String lan : this.languageManager.getLanguages()) {
                graph.addPlotter(new Metrics.Plotter(lan){

                    public int getValue() {
                        return 1;
                    }
                });
            }
            metrics.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void registerEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)new CraftBookVehicleListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CraftBookVehicleBlockListener(this), (Plugin)this);
    }

    public VehiclesConfiguration getLocalConfiguration() {
        return this.config;
    }

    public static VehiclesPlugin getInstance() {
        return instance;
    }

    public void reloadConfiguration() {
        this.reloadConfig();
        this.config = new VehiclesConfiguration(this.getConfig(), this.getDataFolder());
        this.cartman.reloadConfiguration(this.config);
        this.saveConfig();
    }

    public void setStation(String player, String station) {
        this.stationSelection.put(player, station);
    }

    public String getStation(String player) {
        return this.stationSelection.get(player);
    }

    static class Decay
    implements Runnable {
        Minecart cart;

        public Decay(Minecart cart) {
            this.cart = cart;
        }

        public void run() {
            if (this.cart.isEmpty()) {
                this.cart.setDamage(41);
            }
        }
    }

    class CraftBookVehicleBlockListener
    implements Listener {
        VehiclesPlugin plugin;

        public CraftBookVehicleBlockListener(VehiclesPlugin plugin) {
            this.plugin = plugin;
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
        public void onBlockRedstoneChange(BlockRedstoneEvent event) {
            if (event.getOldCurrent() > 0 == event.getNewCurrent() > 0) {
                return;
            }
            for (BlockFace bf : CartMechanism.powerSupplyOptions) {
                VehiclesPlugin.this.cartman.impact((BlockRedstoneEvent)new SourcedBlockRedstoneEvent(event, event.getBlock().getRelative(bf)));
            }
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
        public void onChunkLoad(ChunkLoadEvent event) {
            if (((VehiclesPlugin)VehiclesPlugin.this).config.minecartDecayWhenEmpty) {
                for (Entity ent : event.getChunk().getEntities()) {
                    if (ent == null || ent.isDead() || !(ent instanceof Minecart) || !ent.isEmpty()) continue;
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new Decay((Minecart)ent), (long)((VehiclesPlugin)VehiclesPlugin.this).config.minecartDecayTime);
                }
            }
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
        public void onSignChange(SignChangeEvent event) {
            Block block = event.getBlock();
            String[] lines = event.getLines();
            LocalPlayer player = VehiclesPlugin.this.wrap(event.getPlayer());
            try {
                for (CartMechanism mech : ((VehiclesPlugin)VehiclesPlugin.this).cartman.mechanisms.values()) {
                    if (mech.getApplicableSigns() == null) continue;
                    boolean found = false;
                    String linefound = null;
                    int linenum = 1;
                    for (String sign : mech.getApplicableSigns()) {
                        if (lines[1].equalsIgnoreCase("[" + sign + "]")) {
                            found = true;
                            linefound = sign;
                            linenum = 1;
                            break;
                        }
                        if (!mech.getName().equalsIgnoreCase("messager") || !lines[0].equalsIgnoreCase("[" + sign + "]")) continue;
                        found = true;
                        linefound = sign;
                        linenum = 0;
                        break;
                    }
                    if (!found) continue;
                    if (!mech.verify(BukkitUtil.toChangedSign((Sign)((Sign)event.getBlock().getState()), (String[])lines), player)) {
                        block.breakNaturally();
                        event.setCancelled(true);
                        return;
                    }
                    player.checkPermission("craftbook.vehicles." + mech.getName().toLowerCase());
                    event.setLine(linenum, "[" + linefound + "]");
                    player.print(mech.getName() + " Created!");
                }
            }
            catch (InsufficientPermissionsException e) {
                player.printError("vehicles.create-permission");
                block.breakNaturally();
                event.setCancelled(true);
            }
        }
    }

    class CraftBookVehicleListener
    implements Listener {
        VehiclesPlugin plugin;

        public CraftBookVehicleListener(VehiclesPlugin plugin) {
            this.plugin = plugin;
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
        public void onVehicleEntityCollision(VehicleEntityCollisionEvent event) {
            VehiclesConfiguration config = VehiclesPlugin.this.getLocalConfiguration();
            Vehicle vehicle = event.getVehicle();
            Entity entity = event.getEntity();
            if (!(config.boatRemoveEntities || config.minecartRemoveEntities || config.minecartEnterOnImpact)) {
                return;
            }
            if (config.minecartEnterOnImpact && vehicle instanceof Minecart) {
                if (!vehicle.isEmpty()) {
                    return;
                }
                if (!(event.getEntity() instanceof LivingEntity)) {
                    return;
                }
                vehicle.setPassenger(event.getEntity());
                return;
            }
            if (config.boatRemoveEntities && vehicle instanceof Boat) {
                if (!config.boatRemoveEntitiesOtherBoats && entity instanceof Boat) {
                    return;
                }
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).damage(5);
                    entity.setVelocity(vehicle.getVelocity().multiply(2));
                } else {
                    entity.remove();
                }
                return;
            }
            if (config.minecartRemoveEntities && vehicle instanceof Minecart) {
                if (!config.minecartRemoveEntitiesOtherCarts && entity instanceof Minecart) {
                    return;
                }
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).damage(5);
                    entity.setVelocity(vehicle.getVelocity().multiply(2));
                } else {
                    entity.remove();
                }
            }
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
        public void onVehicleCreate(VehicleCreateEvent event) {
            Vehicle vehicle = event.getVehicle();
            if (!(vehicle instanceof Minecart)) {
                return;
            }
            VehiclesConfiguration config = VehiclesPlugin.this.getLocalConfiguration();
            Minecart minecart = (Minecart)vehicle;
            minecart.setSlowWhenEmpty(config.minecartSlowWhenEmpty);
            if (config.minecartOffRailSpeedModifier > 0.0) {
                minecart.setDerailedVelocityMod(new Vector(config.minecartOffRailSpeedModifier, config.minecartOffRailSpeedModifier, config.minecartOffRailSpeedModifier));
            }
            minecart.setMaxSpeed(minecart.getMaxSpeed() * config.minecartMaxSpeedModifier);
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
        public void onVehicleEnter(VehicleEnterEvent event) {
            Vehicle vehicle = event.getVehicle();
            if (!(vehicle instanceof Minecart)) {
                return;
            }
            VehiclesPlugin.this.cartman.enter(event);
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
        public void onVehicleExit(VehicleExitEvent event) {
            Vehicle vehicle = event.getVehicle();
            if (!(vehicle instanceof Minecart)) {
                return;
            }
            VehiclesConfiguration config = VehiclesPlugin.this.getLocalConfiguration();
            if (config.minecartRemoveOnExit) {
                vehicle.remove();
            } else if (config.minecartDecayWhenEmpty) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new Decay((Minecart)vehicle), (long)config.minecartDecayTime);
            }
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
        public void onVehicleMove(VehicleMoveEvent event) {
            if (!(event.getVehicle() instanceof Minecart)) {
                return;
            }
            if (((VehiclesPlugin)VehiclesPlugin.this).config.minecartConstantSpeed > 0.0 && RailUtil.isTrack(event.getTo().getBlock().getTypeId()) && event.getVehicle().getVelocity().lengthSquared() > 0.0) {
                Vector vel = event.getVehicle().getVelocity();
                event.getVehicle().setVelocity(vel.normalize().multiply(((VehiclesPlugin)VehiclesPlugin.this).config.minecartConstantSpeed));
            }
            VehiclesPlugin.this.cartman.impact(event);
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
        public void onVehicleDestroy(VehicleDestroyEvent event) {
            if (!(event.getVehicle() instanceof Boat)) {
                return;
            }
            VehiclesConfiguration config = VehiclesPlugin.this.getLocalConfiguration();
            if (config.boatNoCrash && event.getAttacker() == null) {
                event.getVehicle().setVelocity(new Vector(0, 0, 0));
                event.setCancelled(true);
            } else if (config.boatBreakReturn && event.getAttacker() == null) {
                Boat boat = (Boat)event.getVehicle();
                boat.getLocation().getWorld().dropItemNaturally(boat.getLocation(), new ItemStack(333));
                boat.remove();
                event.setCancelled(true);
            }
        }
    }
}

