/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook;

import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public abstract class RedstoneUtil {
    public static Power isPowered(Block mech, BlockFace face) {
        Block pow = mech.getRelative(face);
        if (RedstoneUtil.isPotentialPowerSource(mech, pow)) {
            if (pow.isBlockPowered() || pow.isBlockIndirectlyPowered()) {
                return Power.ON;
            }
            return Power.OFF;
        }
        return Power.NA;
    }

    public static boolean isPotentialPowerSource(int typeId) {
        return typeId == 55 || typeId == 94 || typeId == 93 || typeId == 69 || typeId == 76 || typeId == 75 || typeId == 72 || typeId == 70;
    }

    public static boolean isPotentialPowerSource(Block pow) {
        return pow.getTypeId() == 55 || pow.getTypeId() == 93 || pow.getTypeId() == 94;
    }

    public static boolean isPotentialPowerSource(Block mech, Block pow) {
        return pow.getTypeId() == 55 || pow.getTypeId() == 93 || pow.getTypeId() == 94;
    }

    public static void debug(Block block) {
        System.out.println("block " + block + " power debug:");
        System.out.println("\tblock.isBlockPowered() : " + block.isBlockPowered());
        System.out.println("\tblock.isBlockIndirectlyPowered() : " + block.isBlockIndirectlyPowered());
        for (BlockFace bf : BlockFace.values()) {
            System.out.println("\tblock.isBlockFacePowered(" + bf + ") : " + block.isBlockFacePowered(bf));
            System.out.println("\tblock.getFace(" + bf + ").isBlockPowered() : " + block.getRelative(bf).isBlockPowered());
            System.out.println("\tblock.isBlockFaceIndirectlyPowered(" + bf + ") : " + block.isBlockFaceIndirectlyPowered(bf));
            System.out.println("\tblock.getFace(" + bf + ").isBlockIndirectlyPowered(" + bf + ") : " + block.getRelative(bf).isBlockIndirectlyPowered());
        }
        System.out.println();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Power {
        NA,
        ON,
        OFF;

    }
}

