/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.bukkit;

import com.sk89q.craftbook.InsufficientPermissionsException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.Vehicle;
import com.sk89q.craftbook.bukkit.BaseBukkitPlugin;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.worldedit.Location;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BlockType;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitPlayer
implements LocalPlayer {
    protected final BaseBukkitPlugin plugin;
    protected final Player player;

    public Player getPlayer() {
        return this.player;
    }

    public BukkitPlayer(BaseBukkitPlugin plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    public void print(String message) {
        if (message == null) {
            return;
        }
        this.player.sendMessage(ChatColor.GOLD + this.plugin.getLanguageManager().getString(message, this.plugin.getLanguageManager().getPlayersLanguage(this.player)));
    }

    public void printError(String message) {
        this.player.sendMessage(ChatColor.RED + this.plugin.getLanguageManager().getString(message, this.plugin.getLanguageManager().getPlayersLanguage(this.player)));
    }

    public void printRaw(String message) {
        this.player.sendMessage(this.plugin.getLanguageManager().getString(message, this.plugin.getLanguageManager().getPlayersLanguage(this.player)));
    }

    public boolean hasPermission(String perm) {
        return this.plugin.hasPermission((CommandSender)this.player, perm);
    }

    public void checkPermission(String perm) throws InsufficientPermissionsException {
        if (!this.hasPermission(perm)) {
            throw new InsufficientPermissionsException();
        }
    }

    public String getName() {
        return this.player.getName();
    }

    public Location getPosition() {
        return BukkitUtil.toLocation(this.player.getLocation());
    }

    public void teleport(Location location) {
        this.player.teleport(BukkitUtil.toLocation(location));
    }

    public void setPosition(Vector pos, float pitch, float yaw) {
        this.player.teleport(new org.bukkit.Location(this.player.getWorld(), pos.getX(), pos.getY(), pos.getZ(), yaw, pitch));
    }

    public boolean isInsideVehicle() {
        return this.player.isInsideVehicle();
    }

    public Vehicle getVehicle() {
        return BukkitUtil.toVehicle((org.bukkit.entity.Vehicle)this.player.getVehicle());
    }

    public int getTypeInHand() {
        if (this.player.getItemInHand() == null) {
            return 0;
        }
        return this.player.getItemInHand().getTypeId();
    }

    public boolean isHoldingBlock() {
        return BlockType.fromID((int)this.getTypeInHand()) != null;
    }

    public String translate(String message) {
        return this.plugin.getLanguageManager().getString(message, this.plugin.getLanguageManager().getPlayersLanguage(this.player));
    }
}

