/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.bukkit;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitChangedSign;
import com.sk89q.craftbook.bukkit.BukkitVehicle;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Location;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.bukkit.entity.BukkitEntity;
import com.sk89q.worldedit.bukkit.entity.BukkitExpOrb;
import com.sk89q.worldedit.bukkit.entity.BukkitItem;
import com.sk89q.worldedit.bukkit.entity.BukkitPainting;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;

public class BukkitUtil {
    private static final Map<World, LocalWorld> wlw = new HashMap<World, LocalWorld>();
    public static final double EQUALS_PRECISION = 1.0E-4;

    private BukkitUtil() {
    }

    public static ChangedSign toChangedSign(Sign sign) {
        return BukkitUtil.toChangedSign(sign, sign.getLines());
    }

    public static ChangedSign toChangedSign(Block sign) {
        if (!(sign.getState() instanceof Sign)) {
            return null;
        }
        return BukkitUtil.toChangedSign((Sign)sign.getState(), ((Sign)sign.getState()).getLines());
    }

    public static ChangedSign toChangedSign(Sign sign, String[] lines) {
        return new BukkitChangedSign(sign, lines);
    }

    public static Sign toSign(ChangedSign sign) {
        return ((BukkitChangedSign)sign).sign;
    }

    public static LocalWorld getLocalWorld(World w) {
        LocalWorld lw = wlw.get(w);
        if (lw == null) {
            lw = new BukkitWorld(w);
            wlw.put(w, lw);
        }
        return lw;
    }

    public static BlockVector toVector(Block block) {
        return new BlockVector(block.getX(), block.getY(), block.getZ());
    }

    public static BlockVector toVector(BlockFace face) {
        return new BlockVector(face.getModX(), face.getModY(), face.getModZ());
    }

    public static BlockWorldVector toWorldVector(Block block) {
        return new BlockWorldVector(BukkitUtil.getLocalWorld(block.getWorld()), block.getX(), block.getY(), block.getZ());
    }

    public static Vector toVector(org.bukkit.Location loc) {
        return new Vector(loc.getX(), loc.getY(), loc.getZ());
    }

    public static Location toLocation(org.bukkit.Location loc) {
        return new Location(BukkitUtil.getLocalWorld(loc.getWorld()), new Vector(loc.getX(), loc.getY(), loc.getZ()), loc.getYaw(), loc.getPitch());
    }

    public static Vector toVector(org.bukkit.util.Vector vector) {
        return new Vector(vector.getX(), vector.getY(), vector.getZ());
    }

    public static org.bukkit.Location toLocation(WorldVector pt) {
        return new org.bukkit.Location(BukkitUtil.toWorld(pt), pt.getX(), pt.getY(), pt.getZ());
    }

    public static org.bukkit.Location toLocation(World world, Vector pt) {
        return new org.bukkit.Location(world, pt.getX(), pt.getY(), pt.getZ());
    }

    public static org.bukkit.Location center(org.bukkit.Location loc) {
        return new org.bukkit.Location(loc.getWorld(), (double)loc.getBlockX() + 0.5, (double)loc.getBlockY() + 0.5, (double)loc.getBlockZ() + 0.5, loc.getPitch(), loc.getYaw());
    }

    public static Player matchSinglePlayer(Server server, String name) {
        List players = server.matchPlayer(name);
        if (players.isEmpty()) {
            return null;
        }
        return (Player)players.get(0);
    }

    public static Block toBlock(BlockWorldVector pt) {
        return BukkitUtil.toWorld((WorldVector)pt).getBlockAt(BukkitUtil.toLocation((WorldVector)pt));
    }

    public static World toWorld(WorldVector pt) {
        return ((BukkitWorld)pt.getWorld()).getWorld();
    }

    public static boolean equals(org.bukkit.Location a, org.bukkit.Location b) {
        return Math.abs(a.getX() - b.getX()) <= 1.0E-4 && Math.abs(a.getY() - b.getY()) <= 1.0E-4 && Math.abs(a.getZ() - b.getZ()) <= 1.0E-4;
    }

    public static org.bukkit.Location toLocation(Location teleportLocation) {
        Vector pt = teleportLocation.getPosition();
        return new org.bukkit.Location(BukkitUtil.toWorld(teleportLocation.getWorld()), pt.getX(), pt.getY(), pt.getZ(), teleportLocation.getYaw(), teleportLocation.getPitch());
    }

    public static World toWorld(LocalWorld world) {
        return ((BukkitWorld)world).getWorld();
    }

    public static BukkitEntity toLocalEntity(Entity e) {
        switch (e.getType()) {
            case EXPERIENCE_ORB: {
                return new BukkitExpOrb(BukkitUtil.toLocation(e.getLocation()), e.getUniqueId(), ((ExperienceOrb)e).getExperience());
            }
            case PAINTING: {
                Painting paint = (Painting)e;
                return new BukkitPainting(BukkitUtil.toLocation(e.getLocation()), paint.getArt(), paint.getFacing(), e.getUniqueId());
            }
            case DROPPED_ITEM: {
                return new BukkitItem(BukkitUtil.toLocation(e.getLocation()), ((Item)e).getItemStack(), e.getUniqueId());
            }
        }
        return new BukkitEntity(BukkitUtil.toLocation(e.getLocation()), e.getType(), e.getUniqueId());
    }

    public static BukkitVehicle toVehicle(Vehicle vehicle) {
        return new BukkitVehicle(vehicle);
    }
}

