/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.cart;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.blocks.BlockType;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class CartMechanismBlocks {
    public final Block rail;
    public final Block base;
    public final Block sign;
    public Block from;

    private CartMechanismBlocks(Block rail, Block base, Block sign) {
        this.rail = rail;
        this.base = base;
        this.sign = sign;
    }

    public static CartMechanismBlocks find(Block unknown) throws InvalidMechanismException {
        int ti = unknown.getTypeId();
        if (SignUtil.isSign((int)ti)) {
            return CartMechanismBlocks.findBySign(unknown);
        }
        if (BlockType.isRailBlock((int)ti)) {
            return CartMechanismBlocks.findByRail(unknown);
        }
        return CartMechanismBlocks.findByBase(unknown);
    }

    public static CartMechanismBlocks findByRail(Block rail) throws InvalidMechanismException {
        if (!BlockType.isRailBlock((int)rail.getTypeId())) {
            throw new InvalidMechanismException("rail argument must be a rail!");
        }
        if (SignUtil.isSign((int)rail.getRelative(BlockFace.DOWN, 2).getTypeId())) {
            return new CartMechanismBlocks(rail, rail.getRelative(BlockFace.DOWN, 1), rail.getRelative(BlockFace.DOWN, 2));
        }
        if (SignUtil.isSign((int)rail.getRelative(BlockFace.DOWN, 3).getTypeId())) {
            return new CartMechanismBlocks(rail, rail.getRelative(BlockFace.DOWN, 1), rail.getRelative(BlockFace.DOWN, 3));
        }
        if (SignUtil.isSign((int)rail.getRelative(BlockFace.DOWN, 1).getRelative(BlockFace.EAST, 1).getTypeId())) {
            return new CartMechanismBlocks(rail, rail.getRelative(BlockFace.DOWN, 1), rail.getRelative(BlockFace.DOWN, 1).getRelative(BlockFace.EAST, 1));
        }
        if (SignUtil.isSign((int)rail.getRelative(BlockFace.DOWN, 1).getRelative(BlockFace.WEST, 1).getTypeId())) {
            return new CartMechanismBlocks(rail, rail.getRelative(BlockFace.DOWN, 1), rail.getRelative(BlockFace.DOWN, 1).getRelative(BlockFace.WEST, 1));
        }
        if (SignUtil.isSign((int)rail.getRelative(BlockFace.DOWN, 1).getRelative(BlockFace.NORTH, 1).getTypeId())) {
            return new CartMechanismBlocks(rail, rail.getRelative(BlockFace.DOWN, 1), rail.getRelative(BlockFace.DOWN, 1).getRelative(BlockFace.NORTH, 1));
        }
        if (SignUtil.isSign((int)rail.getRelative(BlockFace.DOWN, 1).getRelative(BlockFace.SOUTH, 1).getTypeId())) {
            return new CartMechanismBlocks(rail, rail.getRelative(BlockFace.DOWN, 1), rail.getRelative(BlockFace.DOWN, 1).getRelative(BlockFace.SOUTH, 1));
        }
        return new CartMechanismBlocks(rail, rail.getRelative(BlockFace.DOWN, 1), null);
    }

    public static CartMechanismBlocks findByBase(Block base) throws InvalidMechanismException {
        if (!BlockType.isRailBlock((int)base.getRelative(BlockFace.UP, 1).getTypeId())) {
            throw new InvalidMechanismException("could not find rails.");
        }
        if (SignUtil.isSign((int)base.getRelative(BlockFace.DOWN, 1).getTypeId())) {
            return new CartMechanismBlocks(base.getRelative(BlockFace.UP, 1), base, base.getRelative(BlockFace.DOWN, 1));
        }
        if (SignUtil.isSign((int)base.getRelative(BlockFace.DOWN, 2).getTypeId())) {
            return new CartMechanismBlocks(base.getRelative(BlockFace.UP, 1), base, base.getRelative(BlockFace.DOWN, 2));
        }
        if (SignUtil.isSign((int)base.getRelative(BlockFace.EAST, 1).getTypeId())) {
            return new CartMechanismBlocks(base.getRelative(BlockFace.UP, 1), base, base.getRelative(BlockFace.EAST, 1));
        }
        if (SignUtil.isSign((int)base.getRelative(BlockFace.WEST, 1).getTypeId())) {
            return new CartMechanismBlocks(base.getRelative(BlockFace.UP, 1), base, base.getRelative(BlockFace.WEST, 1));
        }
        if (SignUtil.isSign((int)base.getRelative(BlockFace.NORTH, 1).getTypeId())) {
            return new CartMechanismBlocks(base.getRelative(BlockFace.UP, 1), base, base.getRelative(BlockFace.NORTH, 1));
        }
        if (SignUtil.isSign((int)base.getRelative(BlockFace.SOUTH, 1).getTypeId())) {
            return new CartMechanismBlocks(base.getRelative(BlockFace.UP, 1), base, base.getRelative(BlockFace.SOUTH, 1));
        }
        return new CartMechanismBlocks(base.getRelative(BlockFace.UP, 1), base, null);
    }

    public static CartMechanismBlocks findBySign(Block sign) throws InvalidMechanismException {
        if (!SignUtil.isSign((Block)sign)) {
            throw new InvalidMechanismException("sign argument must be a sign!");
        }
        if (BlockType.isRailBlock((int)sign.getRelative(BlockFace.UP, 2).getTypeId())) {
            return new CartMechanismBlocks(sign.getRelative(BlockFace.UP, 2), sign.getRelative(BlockFace.UP, 1), sign);
        }
        if (BlockType.isRailBlock((int)sign.getRelative(BlockFace.UP, 3).getTypeId())) {
            return new CartMechanismBlocks(sign.getRelative(BlockFace.UP, 3), sign.getRelative(BlockFace.UP, 2), sign);
        }
        if (BlockType.isRailBlock((int)sign.getRelative(SignUtil.getBack((Block)sign), 1).getRelative(BlockFace.UP, 1).getTypeId())) {
            return new CartMechanismBlocks(sign.getRelative(SignUtil.getBack((Block)sign), 1).getRelative(BlockFace.UP, 1), sign.getRelative(SignUtil.getBack((Block)sign), 1), sign);
        }
        throw new InvalidMechanismException("could not find rails.");
    }

    public void setFromBlock(Block block) {
        this.from = block;
    }

    public boolean matches(String mechname) {
        return this.sign != null && BukkitUtil.toChangedSign((Block)this.sign).getLine(1).equalsIgnoreCase("[" + mechname + "]");
    }

    public boolean matches(int mat) {
        return this.base.getTypeId() == mat;
    }

    public ChangedSign getSign() {
        return this.sign == null ? null : BukkitUtil.toChangedSign((Block)this.sign);
    }
}

