/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.Mechanic;
import com.sk89q.craftbook.MechanicFactory;
import com.sk89q.craftbook.PersistentMechanic;
import com.sk89q.craftbook.ProcessedMechanismException;
import com.sk89q.craftbook.SelfTriggeringMechanic;
import com.sk89q.craftbook.SourcedBlockRedstoneEvent;
import com.sk89q.craftbook.TriggerBlockManager;
import com.sk89q.craftbook.WatchBlockManager;
import com.sk89q.craftbook.bukkit.BaseBukkitPlugin;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.util.GeneralUtil;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.BlockWorldVector2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MechanicManager {
    public static final boolean DEBUG = false;
    protected final Logger logger = Logger.getLogger("Minecraft.CraftBook");
    protected final BaseBukkitPlugin plugin;
    public final LinkedList<MechanicFactory<? extends Mechanic>> factories;
    private final TriggerBlockManager triggersManager;
    private final WatchBlockManager watchBlockManager;
    private final Set<SelfTriggeringMechanic> thinkingMechanics = new LinkedHashSet<SelfTriggeringMechanic>();
    protected HashMap<Class<?>, ArrayList<MechanicFactory<? extends Mechanic>>> eventRegistration = new HashMap();

    public MechanicManager(BaseBukkitPlugin plugin) {
        this.plugin = plugin;
        this.factories = new LinkedList();
        this.triggersManager = new TriggerBlockManager();
        this.watchBlockManager = new WatchBlockManager();
    }

    public void register(MechanicFactory<? extends Mechanic> factory) {
        if (!this.factories.contains(factory)) {
            this.factories.add(factory);
        }
    }

    public boolean unregister(MechanicFactory<? extends Mechanic> factory) {
        if (this.factories.contains(factory)) {
            this.factories.remove(factory);
            return true;
        }
        return false;
    }

    public boolean dispatchSignChange(SignChangeEvent event) {
        if (!this.passesFilter((Event)event)) {
            return false;
        }
        Block block = event.getBlock();
        BlockWorldVector pos = com.sk89q.worldedit.bukkit.BukkitUtil.toWorldVector((Block)block);
        LocalPlayer localPlayer = this.plugin.wrap(event.getPlayer());
        BlockState state = event.getBlock().getState();
        if (!(state instanceof Sign)) {
            return false;
        }
        Sign sign = (Sign)state;
        try {
            this.load(pos, localPlayer, BukkitUtil.toChangedSign(sign, event.getLines()));
        }
        catch (InvalidMechanismException e) {
            if (e.getMessage() != null) {
                localPlayer.printError(e.getMessage());
            }
            event.setCancelled(true);
            block.getWorld().dropItem(block.getLocation(), new ItemStack(323, 1));
            block.setTypeId(0);
        }
        return false;
    }

    public short dispatchBlockBreak(BlockBreakEvent event) {
        short returnValue;
        block5: {
            if (!this.passesFilter((Event)event)) {
                return 0;
            }
            returnValue = 0;
            LocalPlayer player = this.plugin.wrap(event.getPlayer());
            if (!this.plugin.canBuildInArea(event.getBlock().getLocation(), event.getPlayer())) {
                player.printError("area.permissions");
                return 0;
            }
            this.watchBlockManager.notify((BlockEvent)event);
            BlockWorldVector pos = com.sk89q.worldedit.bukkit.BukkitUtil.toWorldVector((Block)event.getBlock());
            try {
                List<Mechanic> mechanics = this.load(pos);
                for (Mechanic aMechanic : mechanics) {
                    if (aMechanic == null) continue;
                    aMechanic.onBlockBreak(event);
                    returnValue = (short)(returnValue + 1);
                }
            }
            catch (InvalidMechanismException e) {
                if (e.getMessage() == null) break block5;
                player.printError(e.getMessage());
            }
        }
        return returnValue;
    }

    public short dispatchBlockRightClick(PlayerInteractEvent event) {
        short returnValue;
        block5: {
            if (!this.passesFilter((Event)event)) {
                return 0;
            }
            returnValue = 0;
            LocalPlayer player = this.plugin.wrap(event.getPlayer());
            if (!this.plugin.canUseInArea(event.getClickedBlock().getLocation(), event.getPlayer())) {
                player.printError("area.permissions");
                return 0;
            }
            BlockWorldVector pos = com.sk89q.worldedit.bukkit.BukkitUtil.toWorldVector((Block)event.getClickedBlock());
            try {
                List<Mechanic> mechanics = this.load(pos);
                for (Mechanic aMechanic : mechanics) {
                    if (aMechanic == null) continue;
                    aMechanic.onRightClick(event);
                    returnValue = (short)(returnValue + 1);
                }
            }
            catch (InvalidMechanismException e) {
                if (e.getMessage() == null) break block5;
                player.printError(e.getMessage());
            }
        }
        return returnValue;
    }

    public short dispatchBlockLeftClick(PlayerInteractEvent event) {
        short returnValue;
        block5: {
            if (!this.passesFilter((Event)event)) {
                return 0;
            }
            returnValue = 0;
            LocalPlayer player = this.plugin.wrap(event.getPlayer());
            if (!this.plugin.canUseInArea(event.getClickedBlock().getLocation(), event.getPlayer())) {
                player.printError("area.permissions");
                return 0;
            }
            BlockWorldVector pos = com.sk89q.worldedit.bukkit.BukkitUtil.toWorldVector((Block)event.getClickedBlock());
            try {
                List<Mechanic> mechanics = this.load(pos);
                for (Mechanic aMechanic : mechanics) {
                    if (aMechanic == null) continue;
                    aMechanic.onLeftClick(event);
                    returnValue = (short)(returnValue + 1);
                }
            }
            catch (InvalidMechanismException e) {
                if (e.getMessage() == null) break block5;
                player.printError(e.getMessage());
            }
        }
        return returnValue;
    }

    public short dispatchBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!this.passesFilter((Event)event)) {
            return 0;
        }
        short returnValue = 0;
        BlockWorldVector pos = com.sk89q.worldedit.bukkit.BukkitUtil.toWorldVector((Block)event.getBlock());
        try {
            List<Mechanic> mechanics = this.load(pos);
            for (Mechanic aMechanic : mechanics) {
                if (aMechanic == null) continue;
                aMechanic.onBlockRedstoneChange(event);
                returnValue = (short)(returnValue + 1);
            }
        }
        catch (InvalidMechanismException ignored) {
            // empty catch block
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Mechanic> load(BlockWorldVector pos) throws InvalidMechanismException {
        List<Mechanic> detectedMechanics = this.detect(pos);
        PersistentMechanic ptMechanic = this.triggersManager.get(pos);
        if (ptMechanic != null && ptMechanic instanceof PersistentMechanic && !ptMechanic.isActive()) {
            this.unload(ptMechanic, null);
            ptMechanic = null;
        }
        for (Mechanic aMechanic : detectedMechanics) {
            if (ptMechanic != null) break;
            if (aMechanic == null || !(aMechanic instanceof PersistentMechanic)) continue;
            PersistentMechanic pm = (PersistentMechanic)aMechanic;
            this.triggersManager.register(pm);
            this.watchBlockManager.register(pm);
            if (!(aMechanic instanceof SelfTriggeringMechanic)) break;
            MechanicManager mechanicManager = this;
            synchronized (mechanicManager) {
                this.thinkingMechanics.add((SelfTriggeringMechanic)aMechanic);
                break;
            }
        }
        if (ptMechanic != null) {
            ArrayList<Mechanic> removedMechanics = new ArrayList<Mechanic>();
            for (Mechanic aMechanic : detectedMechanics) {
                if (!ptMechanic.getClass().equals(aMechanic.getClass())) continue;
                removedMechanics.add(aMechanic);
            }
            for (Mechanic aMechanic : removedMechanics) {
                if (!detectedMechanics.contains(aMechanic)) continue;
                detectedMechanics.remove(aMechanic);
            }
            detectedMechanics.add(ptMechanic);
        }
        return detectedMechanics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Mechanic> load(BlockWorldVector pos, LocalPlayer player, ChangedSign sign) throws InvalidMechanismException {
        List<Mechanic> detectedMechanics = this.detect(pos, player, sign);
        PersistentMechanic ptMechanic = this.triggersManager.get(pos);
        if (ptMechanic != null && ptMechanic instanceof PersistentMechanic && !ptMechanic.isActive()) {
            this.unload(ptMechanic, null);
            ptMechanic = null;
        }
        for (Mechanic aMechanic : detectedMechanics) {
            if (ptMechanic != null) break;
            if (aMechanic == null || !(aMechanic instanceof PersistentMechanic)) continue;
            PersistentMechanic pm = (PersistentMechanic)aMechanic;
            this.triggersManager.register(pm);
            this.watchBlockManager.register(pm);
            if (!(aMechanic instanceof SelfTriggeringMechanic)) break;
            MechanicManager mechanicManager = this;
            synchronized (mechanicManager) {
                this.thinkingMechanics.add((SelfTriggeringMechanic)aMechanic);
                break;
            }
        }
        if (ptMechanic != null) {
            ArrayList<Mechanic> removedMechanics = new ArrayList<Mechanic>();
            for (Mechanic aMechanic : detectedMechanics) {
                if (!ptMechanic.getClass().equals(aMechanic.getClass())) continue;
                removedMechanics.add(aMechanic);
            }
            for (Mechanic aMechanic : removedMechanics) {
                if (!detectedMechanics.contains(aMechanic)) continue;
                detectedMechanics.remove(aMechanic);
            }
            detectedMechanics.add(ptMechanic);
        }
        return detectedMechanics;
    }

    protected List<Mechanic> detect(BlockWorldVector pos) throws InvalidMechanismException {
        ArrayList<Mechanic> mechanics = new ArrayList<Mechanic>();
        for (MechanicFactory mechanicFactory : this.factories) {
            Object mechanic = mechanicFactory.detect(pos);
            if (mechanic == null) continue;
            mechanics.add((Mechanic)mechanic);
        }
        return mechanics;
    }

    protected List<Mechanic> detect(BlockWorldVector pos, LocalPlayer player, ChangedSign sign) throws InvalidMechanismException {
        ArrayList<Mechanic> mechanics = new ArrayList<Mechanic>();
        for (MechanicFactory mechanicFactory : this.factories) {
            try {
                Object mechanic = mechanicFactory.detect(pos, player, sign);
                if (mechanic == null) continue;
                mechanics.add((Mechanic)mechanic);
            }
            catch (ProcessedMechanismException ignored) {}
        }
        return mechanics;
    }

    protected boolean passesFilter(Event event) {
        return true;
    }

    public void enumerate(Chunk chunk) {
        for (BlockState state : chunk.getTileEntities()) {
            if (state == null || !(state instanceof Sign)) continue;
            try {
                this.load(com.sk89q.worldedit.bukkit.BukkitUtil.toWorldVector((Block)state.getBlock()));
            }
            catch (InvalidMechanismException ignored) {
            }
            catch (Exception t) {
                Bukkit.getLogger().severe(GeneralUtil.getStackTrace(t));
            }
        }
    }

    public void unload(BlockWorldVector2D chunk, ChunkUnloadEvent event) {
        Set<PersistentMechanic> applicable = this.triggersManager.getByChunk(chunk);
        applicable.addAll(this.watchBlockManager.getByChunk(chunk));
        for (Mechanic mechanic : applicable) {
            this.unload(mechanic, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unload(Mechanic mechanic, ChunkUnloadEvent event) {
        if (mechanic == null) {
            this.logger.log(Level.WARNING, "CraftBook mechanic: Failed to unload(Mechanic) - null.");
            return;
        }
        try {
            if (event == null) {
                mechanic.unload();
            } else {
                mechanic.unloadWithEvent(event);
            }
        }
        catch (Throwable t) {
            this.logger.log(Level.WARNING, "CraftBook mechanic: Failed to unload " + mechanic.getClass().getCanonicalName(), t);
            Bukkit.getLogger().severe(GeneralUtil.getStackTrace(t));
        }
        MechanicManager t = this;
        synchronized (t) {
            this.thinkingMechanics.remove(mechanic);
        }
        if (mechanic instanceof PersistentMechanic) {
            PersistentMechanic pm = (PersistentMechanic)mechanic;
            this.triggersManager.deregister(pm);
            this.watchBlockManager.deregister(pm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void think() {
        SelfTriggeringMechanic[] mechs;
        MechanicManager mechanicManager = this;
        synchronized (mechanicManager) {
            mechs = this.thinkingMechanics.toArray(new SelfTriggeringMechanic[this.thinkingMechanics.size()]);
        }
        for (SelfTriggeringMechanic mechanic : mechs) {
            if (mechanic instanceof PersistentMechanic && ((PersistentMechanic)((Object)mechanic)).isActive()) {
                try {
                    mechanic.think();
                }
                catch (Throwable t) {
                    this.logger.log(Level.WARNING, "CraftBook mechanic: Failed to think for " + mechanic.getClass().getCanonicalName(), t);
                    Bukkit.getLogger().severe(GeneralUtil.getStackTrace(t));
                }
                continue;
            }
            this.unload(mechanic, null);
        }
    }

    public void registerEvent(Class<?> event, MechanicFactory<? extends Mechanic> mechanic) {
        ArrayList<MechanicFactory<Mechanic>> list = this.eventRegistration.get(event);
        if (list == null) {
            list = new ArrayList();
        }
        list.add(mechanic);
        this.eventRegistration.put(event, list);
    }
}

