/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook;

import com.sk89q.craftbook.PersistentMechanic;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.BlockWorldVector2D;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TriggerBlockManager {
    private final Map<BlockWorldVector, PersistentMechanic> triggers = new LinkedHashMap<BlockWorldVector, PersistentMechanic>();

    public void register(PersistentMechanic m) {
        for (BlockWorldVector p : m.getTriggerPositions()) {
            this.triggers.put(p, m);
        }
    }

    public void deregister(PersistentMechanic m) {
        for (BlockWorldVector p : m.getTriggerPositions()) {
            this.triggers.put(p, null);
        }
    }

    public PersistentMechanic get(BlockWorldVector p) {
        return this.triggers.get(p);
    }

    public Set<PersistentMechanic> getByChunk(BlockWorldVector2D chunk) {
        HashSet<PersistentMechanic> folks = new HashSet<PersistentMechanic>();
        int chunkX = chunk.getBlockX();
        int chunkZ = chunk.getBlockZ();
        for (Map.Entry<BlockWorldVector, PersistentMechanic> entry : this.triggers.entrySet()) {
            PersistentMechanic pMechanic;
            BlockWorldVector pos = entry.getKey();
            if (!pos.getWorld().equals((Object)chunk.getWorld())) continue;
            int curChunkX = (int)Math.floor((double)pos.getBlockX() / 16.0);
            int curChunkZ = (int)Math.floor((double)pos.getBlockZ() / 16.0);
            if (curChunkX != chunkX || curChunkZ != chunkZ || (pMechanic = entry.getValue()) == null) continue;
            folks.add(entry.getValue());
        }
        return folks;
    }
}

