/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.bukkit;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.LocalWorld;
import org.bukkit.block.Sign;

public class BukkitChangedSign
implements ChangedSign {
    protected final Sign sign;
    protected String[] lines;

    public BukkitChangedSign(Sign sign, String[] lines) {
        this.sign = sign;
        this.lines = lines;
    }

    public BlockWorldVector getBlockVector() {
        return BukkitUtil.toWorldVector(this.sign.getBlock());
    }

    public int getTypeId() {
        return this.sign.getTypeId();
    }

    public byte getLightLevel() {
        return this.sign.getLightLevel();
    }

    public LocalWorld getLocalWorld() {
        return BukkitUtil.getLocalWorld(this.sign.getWorld());
    }

    public int getX() {
        return this.sign.getX();
    }

    public int getY() {
        return this.sign.getY();
    }

    public int getZ() {
        return this.sign.getZ();
    }

    public String[] getLines() {
        return this.lines;
    }

    public String getLine(int index) throws IndexOutOfBoundsException {
        return this.lines[index];
    }

    public void setLine(int index, String line) throws IndexOutOfBoundsException {
        this.sign.setLine(index, line);
        this.lines[index] = line;
    }

    public boolean setTypeId(int type) {
        return this.sign.setTypeId(type);
    }

    public boolean update(boolean force) {
        return this.sign.update(force);
    }

    public byte getRawData() {
        return this.sign.getRawData();
    }

    public void setRawData(byte b) {
        this.sign.setRawData(b);
    }

    public void setLines(String[] lines) {
        this.lines = lines;
    }
}

